if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Roles_UpdateRole]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Roles_UpdateRole]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE PROCEDURE dbo.cs_Roles_UpdateRole
    @ApplicationName  NVARCHAR(256),
    @RoleID           UNIQUEIDENTIFIER,
    @RoleName         NVARCHAR(256),
    @Description      NVARCHAR(256) = NULL
AS
BEGIN

    DECLARE @ErrorCode     INT
    SET @ErrorCode = 0

    DECLARE @TranStarted   BIT
    SET @TranStarted = 0

    IF( @@TRANCOUNT = 0 )
    BEGIN
        BEGIN TRANSACTION
        SET @TranStarted = 1
    END
    ELSE
        SET @TranStarted = 0

    IF( @@ERROR <> 0 )
    BEGIN
        SET @ErrorCode = -1
        GOTO Cleanup
    END

	DECLARE @ApplicationId uniqueidentifier
	SELECT	@ApplicationId = ApplicationId
	FROM	aspnet_Applications
	WHERE	ApplicationName = @ApplicationName

    UPDATE	aspnet_Roles
    SET		RoleName = @RoleName,
		LoweredRoleName = LOWER(@RoleName),
		Description = @Description
	WHERE	RoleId = @RoleID AND ApplicationId = @ApplicationId

    IF( @@ERROR <> 0 )
    BEGIN
        SET @ErrorCode = -1
        GOTO Cleanup
    END

    IF( @TranStarted = 1 )
    BEGIN
        SET @TranStarted = 0
        COMMIT TRANSACTION
    END

    RETURN(0)

Cleanup:

    IF( @TranStarted = 1 )
    BEGIN
        SET @TranStarted = 0
        ROLLBACK TRANSACTION
    END

    RETURN @ErrorCode

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_Roles_UpdateRole]  TO [public]
GO
