SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Roles_GetRoleIdsForUsers]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Roles_GetRoleIdsForUsers]
GO



set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[cs_Roles_GetRoleIdsForUsers]
	@ApplicationName	nvarchar(256),
    @UserNamesXml         NTEXT

AS
BEGIN


DECLARE @idoc int
	
EXEC sp_xml_preparedocument @idoc OUTPUT, @UserNamesXml


	SELECT DISTINCT
		U.[UserName],
		UIR.UserId,
		UIR.RoleId
	FROM
		aspnet_Applications A
		INNER JOIN dbo.aspnet_Users U ON A.ApplicationId = U.ApplicationId
		INNER JOIN dbo.aspnet_UsersInRoles UIR ON U.UserId = UIR.UserId
		INNER JOIN OPENXML(@idoc, '/UserNames/UserName', 2) WITH (UserName nvarchar(256) '.') X on U.LoweredUserName = LOWER(X.UserName)
	WHERE
		A.LoweredApplicationName = LOWER(@ApplicationName)
	ORDER BY U.UserName

EXEC sp_xml_removedocument @idoc

END



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Roles_GetRoleIdsForUsers] to public
go