SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Roles_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Roles_Get]
GO

CREATE   procedure [dbo].cs_Roles_Get
(
	@UserName NVARCHAR(256) = NULL,
	@ApplicationName NVARCHAR(256)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN

	IF (@UserName IS NULL OR LEN(@UserName) = 0)
		SELECT
			R.RoleId,
			R.RoleName as [Name],
			R.Description
		FROM
			aspnet_Roles R
			INNER JOIN aspnet_Applications A ON R.ApplicationId = A.ApplicationId
		WHERE
			A.LoweredApplicationName = LOWER(@ApplicationName)
	ELSE
	BEGIN
		DECLARE @UserId UNIQUEIDENTIFIER
		SELECT
			@UserId = U.UserId
		FROM
			aspnet_Users U
			INNER JOIN aspnet_Applications A ON U.ApplicationId = A.ApplicationId
		WHERE
			U.LoweredUserName = LOWER(@UserName)
			AND A.LoweredApplicationName = LOWER(@ApplicationName)

		SELECT DISTINCT
			R.RoleId,
			R.RoleName as [Name],
			R.Description
		FROM 
			aspnet_UsersInRoles UIR
			INNER JOIN aspnet_Roles R ON UIR.RoleId = R.RoleId
			INNER JOIN aspnet_Applications A ON R.ApplicationId = A.ApplicationId
		WHERE
			UIR.UserId = @UserId AND
			A.LoweredApplicationName = LOWER(@ApplicationName)
	END
END





GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Roles_Get] to public
go