SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Role_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Role_Get]
GO


--We will need to filter all by application name

create procedure [dbo].cs_Role_Get
(
	@RoleID uniqueidentifier = null,
	@RoleName nvarchar(256) = null,
	@ApplicationName NVARCHAR(256)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN

	SELECT
		R.RoleId,
		R.RoleName as [Name],
		R.Description
	FROM
		aspnet_Roles R
		INNER JOIN aspnet_Applications A ON R.ApplicationId = A.ApplicationId
	WHERE
		((@RoleID IS NOT NULL AND RoleId = @RoleID) OR @RoleID IS NULL) AND
		((@RoleName IS NOT NULL AND RoleName = @RoleName) OR @RoleName IS NULL) AND
		(A.LoweredApplicationName = LOWER(@ApplicationName))

END







GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO









GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Role_Get] to public
go