SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_referrals_Add]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_referrals_Add]
GO
create procedure [dbo].[cs_referrals_Add]
(
	@UrlID int,
	@Url nvarchar(512),
	@SettingsID int,
	@SectionID int,
	@PostID int	
)
as
begin
	set transaction isolation level read uncommitted
	
	exec cs_Urls_Add @UrlID, @Url
	
	-- update the hit count for the SettingsID, SectionID, UrlID and PostID
	update r
	set 
		r.Hits = r.Hits + 1,
		r.LastDate = getdate()
	from
		cs_Referrals r
	where
		r.SettingsID = @SettingsID
		and r.SectionID = @SectionID
		and r.UrlID = @UrlID
		and r.PostID = @PostID
	
	if(@@ROWCOUNT = 0)
	begin
		-- insert the first hit count for the SettingsID, SectionID, UrlID and PostID
		insert cs_Referrals (SettingsID, SectionID, PostID, UrlID, Hits, LastDate)
		values (@SettingsID, @SectionID, @PostID, @UrlID, 1, getdate())
	end
end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_referrals_Add] to public
go