SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Posts_Views_Add]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Posts_Views_Add]
GO

Create Proc [dbo].[cs_Posts_Views_Add]
(
	@PostID int,
	@AggCount int,
	@WebCount int,
	@WebThreadCount int
)

as
begin
	SET Transaction Isolation Level Read UNCOMMITTED
	
	declare @ThreadID int
	declare @SectionID int
	
	-- using a non-documented "feature" of sql server that allows you
	-- to set a variable in an UPDATE statement.  This allows us to get
	-- a cheap read on the cs_Posts table.
	Update
		p
	Set 
		p.TotalViews = p.TotalViews + @WebCount,
		p.AggViews = p.AggViews + @AggCount,
		
		-- set some local variables for later queries
		@ThreadID = p.ThreadID,
		@SectionID = p.SectionID
	from
		cs_Posts p
	Where
		p.PostID = @PostID
	
	IF @WebThreadCount > 0 BEGIN
		update
			t
		set
			t.TotalViews = t.TotalViews + @WebThreadCount
		from
			cs_Threads t
		where
			t.ThreadID = @ThreadID
	END
	
	-- UPDATE Daily Views
	DECLARE @TotalViews int
	SET @TotalViews = @AggCount + @WebThreadCount
	IF @TotalViews > 0 BEGIN
		exec cs_Thread_Daily_Stats_Increment @SectionID, @ThreadID, @TotalViews
	END
end
go
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO

grant execute on [dbo].[cs_Posts_Views_Add] to public
go