SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Posts_UpdatePostsInCategories]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Posts_UpdatePostsInCategories]
GO

CREATE PROCEDURE [dbo].[cs_Posts_UpdatePostsInCategories]
(
	@CategoryList nvarchar(4000) = null,
	@SectionID int,
	@PostID int,
	@SettingsID int = null,
	@UpdateStats bit = 1
)
as
begin

	set nocount on
	
	-- If the post is not in any categories, we have to rebuild the index incase we are deleting a post or removing categories
	IF @CategoryList Is Not Null AND LEN(LTRIM(RTRIM(@CategoryList))) > 0
	BEGIN
		DECLARE @idoc int
		-- declare @CategoryList nvarchar(4000)
		-- select @CategoryList = "<?xml version=""1.0"" ?><Categories><Category>Test</Category></Categories>"

		DECLARE @CategoryNameList TABLE (
			CategoryName nvarchar(255) collate database_default not null
		)
		EXEC sp_xml_preparedocument @idoc OUTPUT, @CategoryList
		
		insert into @CategoryNameList(CategoryName)
		Select DISTINCT
			CONVERT(nvarchar(255), X.[text])
		FROM 
			OPENXML(@idoc, '/Categories/Category/', 2) X
		where 
			X.[text] is not null  

		EXEC sp_xml_removedocument @idoc
		
		--Insert Missing Categories
		INSERT INTO cs_Post_Categories (SectionID, [Name], IsEnabled, ParentID, [Description], SettingsID)
		Select
			@SectionID, X.CategoryName, 1, 0, null, @SettingsID
		FROM 
			@CategoryNameList X
		where 
			not exists (
				Select 1 FROM cs_Post_Categories pc
				where
					X.CategoryName = pc.[Name]
					and pc.SectionID = @SectionID
			) 
		
		IF @@ROWCOUNT > 0
			exec [cs_PostCategories_Parents_RebuildIndex] @SectionID

		--Insert Entry Categories
		INSERT INTO cs_Posts_InCategories ( PostID, CategoryID, SettingsID )
		SELECT
			@PostID, C.CategoryID, @SettingsID
		FROM
			cs_Post_Categories C
		WHERE
			C.SectionID = @SectionID
			and EXISTS (
				select 1 from @CategoryNameList x
				where
					C.[Name] = x.CategoryName
			)
			and not exists (
				select 1 from cs_Posts_InCategories pic
				where
					pic.PostID = @PostID
					and pic.CategoryID = C.CategoryID
					and pic.SettingsID = @SettingsID
			)
		
		DELETE pic FROM cs_Posts_InCategories pic
		WHERE
			pic.PostID = @PostID
			and not exists (
				select 1 from cs_Post_Categories C
				inner join @CategoryNameList x ON C.[Name] = x.CategoryName
				where
					C.CategoryID = pic.CategoryID
			)
		
	END ELSE BEGIN
	
		DELETE pic FROM cs_Posts_InCategories pic
		WHERE pic.PostID = @PostID
	
	END

	if(@UpdateStats = 1) --for changes we need to rebuild the entire section stats
	Begin
		UPDATE pc SET
			pc.TotalSubThreads = IsNull(QSUB.posts, 0),
			pc.MostRecentSubPostDate = QSUB.postdate,
			pc.TotalThreads = IsNull(QCURR.posts, 0),
			pc.MostRecentPostDate = QCURR.postdate
		FROM cs_Post_Categories pc
		LEFT JOIN (
			SELECT P.UpLevelID CategoryID, COUNT(PIC.PostID) posts, MAX(jP.PostDate) postdate
			FROM
				cs_Posts_InCategories PIC
				INNER JOIN cs_Posts jP
					ON jP.PostID = PIC.PostID AND jP.IsApproved = 1 AND jP.PostLevel = 1
				INNER JOIN cs_Post_Categories_Parents P
					ON PIC.CategoryID = P.CategoryID AND jP.SectionID = P.SectionID AND P.SectionID = @SectionID
				INNER JOIN cs_Post_Categories C
					ON C.CategoryID = P.CategoryID
			GROUP BY P.UpLevelID
		) QSUB ON pc.CategoryID = QSUB.CategoryID
		LEFT JOIN (
			SELECT PIC.CategoryID CategoryID, COUNT(PIC.PostID) posts, MAX(jP.PostDate) postdate 
			FROM 
				cs_Posts_InCategories PIC 
				INNER JOIN cs_Posts jP
					ON jP.PostID = PIC.PostID AND jP.SectionID = @SectionID AND jP.PostLevel = 1 AND jP.IsApproved = 1
			GROUP BY PIC.CategoryID
		) QCURR ON pc.CategoryID = QCURR.CategoryID
		WHERE
			pc.SectionID = @SectionID
	End
end
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Posts_UpdatePostsInCategories] to public
go
