SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Posts_ReindexByUser]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Posts_ReindexByUser]
GO


CREATE PROCEDURE [dbo].[cs_Posts_ReindexByUser]
(
	@UserID	int
)
AS
	--this proc intentionally renames all posts across all settingsids by that user


	-- first, set the post to be removed from the index
	INSERT INTO	cs_es_Search_RemoveQueue (PostID, SettingsID, ApplicationType)
	SELECT		P.PostID, P.SettingsID, A.ApplicationName
	FROM		cs_Posts P
	INNER JOIN cs_Sections S ON S.SectionID = P.SectionID
	INNER JOIN cs_ApplicationType A ON A.ApplicationType = S.ApplicationType
	WHERE		P.UserID = @UserID
		AND	P.PostID NOT IN (SELECT PostID FROM cs_es_Search_RemoveQueue)

	-- step 2, add post to reindex table
	UPDATE	cs_Posts
	SET		IsIndexed =  0
	WHERE	UserID = @UserID
GO


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Posts_ReindexByUser] to public
go