SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Posts_ReindexByTag]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Posts_ReindexByTag]
GO


CREATE PROCEDURE [dbo].[cs_Posts_ReindexByTag]
(
	@CategoryID	int,
	@SettingsID	int
)
AS
	-- first, set the post to be removed from the index
	INSERT cs_es_Search_RemoveQueue (PostID, SettingsID, ApplicationType) 
	SELECT P.PostID, P.SettingsID, A.ApplicationName 
	FROM cs_Posts P 
	JOIN cs_Posts_InCategories PIC on P.PostID = PIC.PostID 
	INNER JOIN cs_Sections S ON S.SectionID = P.SectionID
	INNER JOIN cs_ApplicationType A ON A.ApplicationType = S.ApplicationType
	WHERE PIC.CategoryID = @CategoryID AND P.SettingsID = @SettingsID
	AND	P.PostID NOT IN (SELECT PostID FROM cs_es_Search_RemoveQueue)

	-- step 2, reset post to be indexed
	UPDATE cs_Posts set IsIndexed = 0 
	From cs_Posts P 
		JOIN cs_Posts_InCategories PIC on P.PostID = PIC.PostID 
	WHERE PIC.CategoryID = @CategoryID AND P.SettingsID = @SettingsID
GO


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Posts_ReindexByTag] to public
go