SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_OpenID_GetUserID]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_OpenID_GetUserID]
GO




CREATE PROCEDURE [dbo].[cs_OpenID_GetUserID]
(
	@OpenID nvarchar(512),
	@SettingsID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED

Declare @UserID int

	Select @UserID = UserID From cs_Users_OpenID where OpenID = @OpenID and SettingsID = @SettingsID

	if(@UserID is not null)
	Begin
		Update cs_Users_OpenID
		Set LastAccessed = GetDate() where OpenID = @OpenID and SettingsID = @SettingsID
	End

	Select IsNull(@UserID,-1) as UserID


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_OpenID_GetUserID] to public
go