SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_OpenID_AssociateUser]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_OpenID_AssociateUser]
GO




CREATE PROCEDURE [dbo].[cs_OpenID_AssociateUser]
(
	@OpenID nvarchar(512),
	@Email nvarchar(128),
	@UserID int,
	@SettingsID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED

If Not Exists(Select UserID FROM cs_Users_OpenID where OpenID = @OpenID and SettingsID = @SettingsID)
	BEGIN
		Insert cs_Users_OpenID (OpenID, Email, UserID, SettingsID, LastAccessed, Created)
		Values (@OpenID, @Email, @UserID, @SettingsID, GetDate(), GetDate())
	END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_OpenID_AssociateUser] to public
go