SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Moderate_Forum_Roles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Moderate_Forum_Roles]
GO




create procedure [dbo].cs_Moderate_Forum_Roles
(
	@SectionID	int,
	@SettingsID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED

DECLARE @Permissions TABLE
(
	RoleID uniqueidentifier NOT NULL,
	ProductAllow bit NULL,
	ProductDeny bit NULL,
	SectionAllow bit NULL,
	SectionDeny bit NULL
)

INSERT
	@Permissions
SELECT
	PP.RoleID,
	CASE WHEN (PP.AllowMask & CONVERT(bigint, 0x0000100000000000)) = (0x0000100000000000) THEN 1 ELSE 0 END,
	CASE WHEN (PP.DenyMask & CONVERT(bigint, 0x0000100000000000)) = (0x0000100000000000) THEN 1 ELSE 0 END, 
	NULL,
	NULL
FROM
	cs_ProductPermissions PP
WHERE
	PP.ApplicationType = 0
	AND PP.SettingsID = @SettingsID

UPDATE
	P
SET
	SectionAllow = CASE WHEN (SP.AllowMask & CONVERT(bigint, 0x0000100000000000)) = (0x0000100000000000) THEN 1 ELSE 0 END,
	SectionDeny = CASE WHEN (SP.DenyMask & CONVERT(bigint, 0x0000100000000000)) = (0x0000100000000000) THEN 1 ELSE 0 END
FROM
	@Permissions P INNER JOIN cs_SectionPermissions SP ON P.RoleID = SP.RoleID
WHERE
	SP.SectionID = @SectionID
	AND SP.SettingsID = @SettingsID

SELECT
	RoleID
FROM
	@Permissions
WHERE
	SectionAllow = 1 OR
	(ProductAllow = 1 AND ProductDeny = 0 AND SectionAllow IS NULL AND SectionDeny IS NULL)


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].cs_Moderate_Forum_Roles to public
go