SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Messaging_GetActivityMessagesForUserHubs]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Messaging_GetActivityMessagesForUserHubs]
GO

CREATE PROCEDURE [dbo].[cs_Messaging_GetActivityMessagesForUserHubs]
    @userId int,
    @pageIndex int,
    @pageSize int,
	@includedMessageTypes varchar(4000),
    @totalCount int output
AS

DECLARE @rowsToReturn int
DECLARE @pageLowerBound int
DECLARE @pageUpperBound int

-- Create temp table
CREATE TABLE #Temp
(
	IndexId int identity (1, 1) NOT NULL,
	MessageId uniqueidentifier NOT NULL,
    AuthorId int NOT NULL,
    [Subject] nvarchar(100) collate database_default NULL,
    Body ntext collate database_default NULL,
    DateCreated datetime NOT NULL,
    [Type] nvarchar(50) collate database_default NOT NULL,
    GroupId int NULL
)

IF (@includedMessageTypes IS NULL OR LEN(@includedMessageTypes) = 0)
BEGIN

	-- Fill temp table with all the user's activity messages
	INSERT INTO #Temp (MessageId, AuthorId, [Subject], Body, DateCreated, [Type], GroupId)
		SELECT a.MessageId, a.AuthorId, a.Subject, a.Body, a.DateCreated, b.[Type], b.GroupId
		FROM cs_Messaging_Messages a
			INNER JOIN cs_Messaging_ActivityMessages b ON a.MessageId = b.MessageId 
		WHERE b.GroupId IN (
						SELECT SectionID from cs_SectionMembers 
						WHERE UserID = @userId and MembershipType in (1, 2, 4))
		ORDER BY a.DateCreated DESC

	SET @totalCount = @@ROWCOUNT

END ELSE BEGIN
	
	CREATE TABLE #TempMessageTypes ([Type] nvarchar(50) collate database_default NOT NULL)
	
	INSERT INTO #TempMessageTypes exec [dbo].[cs_split_varchar] @str = @includedMessageTypes
		
	INSERT INTO #Temp (MessageId, AuthorId, [Subject], Body, DateCreated, [Type], GroupId)
		SELECT a.MessageId, a.AuthorId, a.Subject, a.Body, a.DateCreated, b.[Type], b.GroupId
		FROM cs_Messaging_Messages a
			INNER JOIN cs_Messaging_ActivityMessages b ON a.MessageId = b.MessageId 
		WHERE EXISTS (
			SELECT 1 FROM cs_SectionMembers sm
			WHERE sm.UserID = @userId
				AND sm.MembershipType in (1, 2, 4)
				AND b.GroupId = sm.SectionID)
		AND b.[Type] in (SELECT [Type] FROM #TempMessageTypes)
		ORDER BY a.DateCreated DESC		
	
	SET @totalCount = @@ROWCOUNT

END

-- Set the rowcount
SET @rowsToReturn = @pageSize * (@pageIndex + 1)
SET ROWCOUNT @rowsToReturn

-- Set the page bounds
SET @pageLowerBound = @pageSize * @pageIndex
SET @pageUpperBound = @pageLowerBound + @pageSize + 1

-- Select from temp table only the proper number of rows
SELECT MessageId, AuthorId, [Subject], Body, DateCreated, [Type]
FROM #Temp
WHERE #Temp.IndexId > @pageLowerBound
AND #Temp.IndexId <  @pageUpperBound 

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Messaging_GetActivityMessagesForUserHubs] TO PUBLIC
GO