SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Membership_ValidatePasswordAnswer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Membership_ValidatePasswordAnswer]
GO


CREATE PROCEDURE [dbo].cs_Membership_ValidatePasswordAnswer
(
	@ApplicationName nvarchar(256),
	@UserName nvarchar(256),
	@PasswordAnswer nvarchar(256),
	@IsValid bit OUTPUT
)
AS

IF EXISTS
(
	SELECT *
	FROM
		aspnet_Applications A
		INNER JOIN aspnet_Users U ON A.ApplicationId = U.ApplicationId
		INNER JOIN aspnet_Membership M ON U.UserId = M.UserId
	WHERE
		A.ApplicationName = @ApplicationName
		AND U.UserName = @UserName
		AND LOWER(M.PasswordAnswer) = LOWER(@PasswordAnswer)
)
	SET @IsValid = 1
ELSE
	SET @IsValid = 0


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Membership_ValidatePasswordAnswer] to public
go