SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Membership_RenameUser]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Membership_RenameUser]
GO



set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[cs_Membership_RenameUser]
    @ApplicationName       NVARCHAR(256),
    @OldUserName           NVARCHAR(256),
    @NewUserName           NVARCHAR(256)

AS
BEGIN

    DECLARE @ApplicationId UNIQUEIDENTIFIER
    SELECT  @ApplicationId = ApplicationId FROM dbo.aspnet_Applications WHERE LOWER(@ApplicationName) = LoweredApplicationName

    -- if new name is available
    IF NOT EXISTS (SELECT * FROM aspnet_Users WHERE ApplicationId = @ApplicationId AND LoweredUserName = LOWER(@NewUserName))
    BEGIN
        -- rename user
        UPDATE  aspnet_Users
        SET     UserName = @NewUserName,
                LoweredUserName = LOWER(@NewUserName)
        WHERE   ApplicationId = @ApplicationId AND UserName = @OldUserName
    END
    ELSE
    BEGIN
        -- new username was already taken
        SELECT 2
    END

    IF (@@ROWCOUNT = 0)
    BEGIN
        -- username not updated (possible old username was incorrect)
        SELECT 0
    END
    ELSE
    BEGIN
        -- username was updated
        SELECT 1
    END

END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Membership_RenameUser] to public
go