SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Membership_IsUserNameTaken]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Membership_IsUserNameTaken]
GO



set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[cs_Membership_IsUserNameTaken]
    @ApplicationName       NVARCHAR(256),
    @UserName              NVARCHAR(256)

AS
BEGIN

    DECLARE @ApplicationId UNIQUEIDENTIFIER
    SELECT  @ApplicationId = ApplicationId FROM dbo.aspnet_Applications WHERE LOWER(@ApplicationName) = LoweredApplicationName

    SELECT  COUNT(*)
    FROM    aspnet_Users
    WHERE   ApplicationId = @ApplicationId AND LoweredUserName = LOWER(@UserName)

END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Membership_IsUserNameTaken] to public
go