SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Membership_GetUsersByName]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Membership_GetUsersByName]
GO



set ANSI_NULLS ON
set QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[cs_Membership_GetUsersByName]
    @ApplicationName       NVARCHAR(256),
    @UserNames         NTEXT

AS
BEGIN

    DECLARE @ApplicationId UNIQUEIDENTIFIER
    SELECT  @ApplicationId = NULL
    SELECT  @ApplicationId = ApplicationId FROM dbo.aspnet_Applications WHERE LOWER(@ApplicationName) = LoweredApplicationName
    IF (@ApplicationId IS NULL)
        RETURN 0


	DECLARE @tbNames	table(Name nvarchar(256) collate database_default NOT NULL PRIMARY KEY) --Has to be removed until we can ensure uniqueness
	DECLARE @tbUsers	table(UserId uniqueidentifier NOT NULL PRIMARY KEY)
	DECLARE @Num		int
	DECLARE @Pos		int
	DECLARE @NextPos	int
	DECLARE @Name		nvarchar(256)

    DECLARE @textpos  int --our chunks position in the ntext
    DECLARE @chunklen smallint
    DECLARE @UserNamesChunk   nvarchar(4000)
	DECLARE @delimiter nvarchar(1)
    DECLARE @leftover nvarchar(4000)

	SET @delimiter = N','
	SET @Num = 0
	SET @textpos = 1
	SET @leftover = ''

	WHILE @textpos <= DATALENGTH(@UserNames) /2
	BEGIN

		SET @chunklen = 4000 - DATALENGTH(@leftover) /2
		SET @UserNamesChunk = ltrim(@leftover + substring(@UserNames, @textpos, @chunklen))
		SET @textpos = @textpos + @chunklen

		SET @Pos = 1 

		WHILE(@Pos <= DATALENGTH(@UserNamesChunk))
		BEGIN
			SELECT @NextPos = CHARINDEX(@delimiter, @UserNamesChunk,  @Pos)
			IF (@NextPos = 0 OR @NextPos IS NULL)
			BEGIN
				--break us from the loop
				SELECT @NextPos = DATALENGTH(@UserNamesChunk) + 1
				--set the leftover string to use again in next iter
				SET @leftover = SUBSTRING(@UserNamesChunk, @Pos, @NextPos - @Pos)
			END
			ELSE
			BEGIN
				SELECT @Name = LOWER(RTRIM(LTRIM(SUBSTRING(@UserNamesChunk, @Pos, @NextPos - @Pos))))

				INSERT INTO @tbNames VALUES (@Name)

				SET @Num = @Num + 1
			END

			SELECT @Pos = @NextPos+1
		END

		IF(@Pos = DATALENGTH(@UserNamesChunk))
			SET @leftover = ''
	END

	INSERT INTO @tbNames VALUES (@leftover)


	INSERT INTO @tbUsers
	  SELECT UserId
	  FROM   dbo.aspnet_Users ar, @tbNames t
	  WHERE  LOWER(t.Name) = ar.LoweredUserName AND ar.ApplicationId = @ApplicationId


    SELECT u.UserName, m.Email, m.PasswordQuestion, m.Comment, m.IsApproved,
            m.CreateDate,
            m.LastLoginDate,
            u.LastActivityDate,
            m.LastPasswordChangedDate,
            u.UserId, m.IsLockedOut,
            m.LastLockoutDate
    FROM   dbo.aspnet_Membership m 
			JOIN dbo.aspnet_Users u ON u.UserId = m.UserId
			JOIN @tbUsers t ON u.UserId = t.UserId
    ORDER BY UserName

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Membership_GetUsersByName] to public
go