SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Membership_ChangePasswordAnswer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Membership_ChangePasswordAnswer]
GO


CREATE PROCEDURE [dbo].cs_Membership_ChangePasswordAnswer
(
	@ApplicationName nvarchar(256),
	@UserName nvarchar(256),
	@PasswordQuestion  nvarchar(256),
	@PasswordAnswer  nvarchar(256)
)
AS

	UPDATE
		M
	SET
		M.PasswordQuestion = @PasswordQuestion,
		M.PasswordAnswer = @PasswordAnswer
	FROM
		aspnet_Applications A
		INNER JOIN aspnet_Users U ON A.ApplicationId = U.ApplicationId
		INNER JOIN aspnet_Membership M ON U.UserId = M.UserId
	WHERE
		A.ApplicationName = @ApplicationName
		AND U.UserName = @UserName

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Membership_ChangePasswordAnswer] to public
go