

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_MarkThreadAsRead]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_MarkThreadAsRead]
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE PROCEDURE dbo.cs_MarkThreadAsRead
	@ThreadID int,
	@SectionID int,
	@UserID int,
	@SettingsID int
 AS

IF NOT EXISTS (SELECT ThreadID FROM cs_ThreadsRead WHERE ThreadID = @ThreadID AND UserID = @UserID and SettingsID = @SettingsID and SectionID = @SectionID)
	INSERT INTO cs_ThreadsRead (UserID, ThreadID, SectionID, SettingsID) VALUES (@UserID, @ThreadID, @SectionID, @SettingsID)

IF @SectionID > 0
BEGIN
	DECLARE @MarkReadAfter int
	SELECT @MarkReadAfter = SR.MarkReadAfter
	FROM cs_SectionsRead SR
	WHERE SR.SettingsID = @SettingsID AND SR.UserID = @UserID AND SR.SectionID = @SectionID
	IF @MarkReadAfter IS NULL
		SET @MarkReadAfter = 0

	-- Check to see if all the threads in this section have been read
	IF (SELECT COUNT(*) 
		FROM cs_Threads T
		LEFT JOIN cs_ThreadsRead TR ON TR.SettingsID = T.SettingsID AND TR.UserID = @UserID AND TR.ThreadID = T.ThreadID AND TR.SectionID = T.SectionID
		WHERE T.SettingsID = @SettingsID AND T.SectionID = @SectionID AND TR.UserID IS NULL AND T.MostRecentPostID >= @MarkReadAfter) = 0
	BEGIN
		-- Update SectionsRead (forum)
		UPDATE cs_SectionsRead 
		SET
			NewPosts = 0,
			MarkReadAfter = (SELECT (MostRecentPostID + 1) FROM cs_Sections WHERE SectionID = @SectionID AND SettingsID = @SettingsID),
			LastActivity = GETDATE()
		WHERE
			SettingsID = @SettingsID
			AND UserID = @UserID
			AND SectionID = @SectionID

		IF @@ROWCOUNT = 0
		BEGIN
			INSERT INTO cs_SectionsRead (
				GroupID,
				SectionID,
				UserID,
				MarkReadAfter,
				NewPosts,
				LastActivity,
				SettingsID
			)
			SELECT
				GroupID,
				SectionID,
				@UserID,
				(MostRecentPostID + 1),
				0,
				GetDate(),
				SettingsID
			FROM
				cs_Sections
			WHERE
				SettingsID = @SettingsID
				AND SectionID = @SectionID
		END
	END
END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_MarkThreadAsRead]  TO [public]
GO

