SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Licenses_GetUsage]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Licenses_GetUsage]
GO

CREATE PROCEDURE dbo.cs_Licenses_GetUsage
AS
begin

	set ansi_warnings off

	declare @NumberOfBlogs int
		, @NumberOfForums int
		, @NumberOfGalleries int
		, @NumberOfGroups int
		, @NumberOfContentMirrors int
		, @NumberOfAddresses int
		, @NumberOfUsers int
		, @NumberOfBlogPosts int
		, @NumberOfBlogComments int
		, @NumberOfForumPosts int
		, @NumberOfForumReplies int
		, @NumberOfMediaGalleryPosts int
		, @NumberOfMediaGalleryComments int
		, @NumberOfFriendRelationships int
		, @NumberOfMessages int

	select
		@NumberOfBlogPosts = NumberOfBlogPosts
		, @NumberOfBlogComments = NumberOfBlogComments
		, @NumberOfForumPosts = NumberOfForumPosts
		, @NumberOfForumReplies = NumberOfForumReplies
		, @NumberOfMediaGalleryPosts = NumberOfMediaGalleryPosts
		, @NumberOfMediaGalleryComments = NumberOfMediaGalleryComments
	from (
		select
			count(case when s.ApplicationType = 1 and p.PostLevel = 1 then p.PostID end) NumberOfBlogPosts
			, count(case when s.ApplicationType = 1 and p.PostLevel > 1 then p.PostID end) NumberOfBlogComments
			, count(case when s.ApplicationType = 0 and ForumType = 0 and p.PostLevel = 1 then p.PostID end) NumberOfForumPosts
			, count(case when s.ApplicationType = 0 and ForumType = 0 and p.PostLevel > 1 then p.PostID end) NumberOfForumReplies
			, count(case when s.ApplicationType = 13 and p.PostLevel = 1 then p.PostID end) NumberOfMediaGalleryPosts
			, count(case when s.ApplicationType = 13 and p.PostLevel > 1 then p.PostID end) NumberOfMediaGalleryComments
		from
			cs_Posts p
		inner join
			cs_Sections s on p.SettingsID = s.SettingsID and p.SectionID = s.SectionID
		where
			s.ApplicationType in (0, 1, 13)
			and s.IsActive = 1
	) as x

	select
		@NumberOfBlogs = NumberOfBlogs
		, @NumberOfForums = NumberOfForums
		, @NumberOfGalleries = NumberOfGalleries
		, @NumberOfGroups = NumberOfGroups
	from (
		select
			count(case when ApplicationType = 11 then SectionID end) as NumberOfGroups
			, count(case when ApplicationType = 0 and ForumType = 0 and HubSectionID = 0 then SectionID end) as NumberOfForums
			, count(case when ApplicationType = 1 and HubSectionID = 0 then SectionID end) as NumberOfBlogs
			, count(case when ApplicationType = 13 and HubSectionID = 0 then SectionID end) as NumberOfGalleries
		from cs_Sections
		where
			ApplicationType in (0, 1, 11, 13)
			and IsActive = 1
	) as x

	set @NumberOfContentMirrors = (select count(UrlID) from cs_RollerBlogFeeds where Enabled = 1)
	set @NumberOfAddresses = (select count(M.SectionID) from csm_MailingLists M left join cs_Sections S on (S.SectionID = M.SectionID) where S.IsActive = 1 and M.IsMailingList = 1)
	set @NumberOfUsers = (select count(UserID) from cs_Users)
	set @NumberOfFriendRelationships = (select count(UserID) from cs_Friends_xref)
	set @NumberOfMessages = (select count(*) from cs_Messaging_Messages)

	set ansi_warnings on

	select
		coalesce(@NumberOfBlogs, 0) NumberOfBlogs
		, coalesce(@NumberOfForums, 0) NumberOfForums
		, coalesce(@NumberOfGalleries, 0) NumberOfGalleries
		, coalesce(@NumberOfGroups, 0) NumberOfGroups
		, coalesce(@NumberOfContentMirrors, 0) NumberOfContentMirrors
		, coalesce(@NumberOfAddresses, 0) NumberOfAddresses
		, coalesce(@NumberOfBlogPosts, 0) NumberOfBlogPosts
		, coalesce(@NumberOfBlogComments, 0) NumberOfBlogComments
		, coalesce(@NumberOfForumPosts, 0) NumberOfForumPosts
		, coalesce(@NumberOfForumReplies, 0) NumberOfForumReplies
		, coalesce(@NumberOfMediaGalleryPosts, 0) NumberOfMediaGalleryPosts
		, coalesce(@NumberOfMediaGalleryComments, 0) NumberOfMediaGalleryComments
		, coalesce(@NumberOfFriendRelationships, 0) NumberOfFriendRelationships
		, coalesce(@NumberOfMessages, 0) NumberOfMessages
		, coalesce(@NumberOfUsers, 0) NumberOfUsers

end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Licenses_GetUsage] to public
go