SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_HubContactRequests_Add]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_HubContactRequests_Add]
GO

CREATE PROCEDURE [dbo].[cs_HubContactRequests_Add]
(
    @Id int OUTPUT,
    @HubId int,
    @Subject nvarchar(256) = '',
    @Name nvarchar(256) = '',
    @EmailAddress nvarchar(256) = '',
    @Body ntext,
    @IsModerated bit,
    @CreationDate datetime
)
AS
BEGIN

	INSERT INTO [cs_Hub_ContactRequests]
	(
		HubId,
		Subject,
		Name,
		EmailAddress,
		CreationDate,
		Body,
		IsModerated
	)
	VALUES
	(
		@HubId,
		@Subject,
		@Name,
		@EmailAddress,
		@CreationDate,
		@Body,
		@IsModerated
	)

	SET @Id = scope_identity()
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_HubContactRequests_Add] TO PUBLIC
GO
