SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cs_Group_Permissions_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Group_Permissions_Get]
GO

create procedure [dbo].[cs_Group_Permissions_Get]
(
	@SettingsID int,
	@GroupID int = 0,
	@ApplicationType smallint
)
AS
begin
	SET Transaction Isolation Level Read UNCOMMITTED
	
	IF (@GroupID > 0)
	BEGIN
		
		-- Return product permissions
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 1), 
			SectionID = -1,
			GroupID = -1,
			ApplicationKey = null,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)), 
			P.ApplicationType 
		FROM
			cs_ProductPermissions P
		WHERE 
			(P.ApplicationType = @ApplicationType or @ApplicationType is null) AND
			P.SettingsID = @SettingsID

		UNION ALL
		
		-- Return the group permissions unioned
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 0), 
			SectionID = -1,
			P.GroupID,
			ApplicationKey = null,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)), 
			ApplicationType = @ApplicationType
		FROM
			cs_GroupPermissions P
		WHERE 
			P.SettingsID = @SettingsID AND 
			P.GroupID = @GroupID
		order by Implied asc
	END
	ELSE -- Return Product Permissions
	BEGIN
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 1), 
			SectionID = -1,
			GroupID = @GroupID,
			ApplicationKey = null,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)), 
			P.ApplicationType 
		FROM
			cs_ProductPermissions P
		WHERE 
			(P.ApplicationType = @ApplicationType or @ApplicationType is null) AND
			P.SettingsID = @SettingsID	
	END	

end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Group_Permissions_Get] to public
go