SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_GetUsersForSectionSubscriptions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_GetUsersForSectionSubscriptions]
GO

CREATE procedure dbo.cs_GetUsersForSectionSubscriptions
(
	@SectionID	int,
	@SettingsID	int
)
AS
	SET Transaction Isolation Level Read UNCOMMITTED

	SELECT
		U.*
	FROM
		cs_vw_Users_FullUser U
		LEFT JOIN cs_TrackedSections TS ON U.UserID = TS.UserID
		LEFT JOIN (cs_TrackedThreads TT INNER JOIN cs_Threads T ON TT.ThreadID = T.ThreadID) ON U.UserID = TT.UserID
	WHERE
		(TS.SectionID IS NULL OR TS.SectionID = @SectionID)
		AND (T.SectionID IS NULL OR T.SectionID = @SectionID)
		AND TS.SettingsID = @SettingsID
		AND U.SettingsID = @SettingsID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_GetUsersForSectionSubscriptions] to public
