SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_GetSectionsForUserSubscriptions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_GetSectionsForUserSubscriptions]
GO

CREATE procedure dbo.cs_GetSectionsForUserSubscriptions
(
	@UserID		int,
	@SettingsID	int
)
AS
	SET Transaction Isolation Level Read UNCOMMITTED

	SELECT
		COALESCE(S.SectionID, T.SectionID) AS SectionID,
		S.ApplicationType
	FROM
		cs_Sections S
		LEFT JOIN cs_TrackedSections TS ON S.SectionID = TS.SectionID
		LEFT JOIN (cs_TrackedThreads TT INNER JOIN cs_Threads T ON TT.ThreadID = T.ThreadID) ON S.SectionID = T.SectionID
	WHERE
		(TS.UserID IS NULL OR TS.UserID = @UserID)
		AND (TT.UserID IS NULL OR TT.UserID = @UserID)
		AND TS.SettingsID = @SettingsID
		AND S.SettingsID = @SettingsID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_GetSectionsForUserSubscriptions] to public
