IF OBJECT_ID(N'[dbo].[cs_FriendRequest_xref_Insert]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_xref_Insert]

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

CREATE PROCEDURE [dbo].[cs_FriendRequest_xref_Insert]
(
	@RequestorUserID int
	, @RequesteeUserID int
	, @FriendshipState tinyint
)

AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON;

BEGIN

	IF (@FriendshipState = 2)
	BEGIN

		IF NOT EXISTS (SELECT 1 FROM cs_Friends_xref WHERE UserID = @RequestorUserID AND FriendUserID = @RequesteeUserID)
			INSERT INTO [dbo].[cs_Friends_xref]
			(
				UserID,
				FriendUserID
			)
			VALUES
			(
				@RequestorUserID,
				@RequesteeUserID
			)

		IF NOT EXISTS (SELECT 1 FROM cs_Friends_xref WHERE UserID = @RequesteeUserID AND FriendUserID = @RequestorUserID)
			INSERT INTO [dbo].[cs_Friends_xref]
			(
				UserID,
				FriendUserID
			)
			VALUES
			(
				@RequesteeUserID,
				@RequestorUserID
			)

	END
	RETURN 0;

END

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

grant execute on [dbo].[cs_FriendRequest_xref_Insert] to [public]
go
