IF OBJECT_ID(N'[dbo].[cs_FriendRequest_UpdateByID]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_UpdateByID]
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
CREATE PROCEDURE [dbo].[cs_FriendRequest_UpdateByID]
(
	@FriendshipRequestID int, 
	@RequestorUserID int, 
	@RequesteeUserID int, 
	@Message varchar(2000), 
	@FriendshipState tinyint 
)

AS

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON;

BEGIN
	
	UPDATE	[dbo].[cs_FriendRequests]
	SET		RequestorUserID = @RequestorUserID, 
			RequesteeUserID = @RequesteeUserID, 
			Message  = @Message, 
			FriendshipState			  = @FriendshipState, 
			LastModifiedDate		  = GETDATE()
	WHERE	FriendshipRequestID			  = @FriendshipRequestID

	EXECUTE [cs_FriendRequest_xref_Insert] @RequestorUserID, @RequesteeUserID, @FriendshipState

	RETURN 0;

END

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_FriendRequest_UpdateByID] to [public]
go
