IF OBJECT_ID(N'[dbo].[cs_FriendRequest_Update]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_Update]
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
CREATE PROCEDURE [dbo].[cs_FriendRequest_Update]
(
	@RequestorUserID	int, 
	@RequesteeUserID	int, 
	@Message	varchar(2000), 
	@FriendshipState			tinyint 
)

AS

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON;

DECLARE @FriendshipRequestID int

BEGIN
	SELECT	@FriendshipRequestID = FriendshipRequestID
	FROM	[dbo].[cs_FriendRequests]
	WHERE	(RequestorUserID = @RequestorUserID OR RequesteeUserID = @RequestorUserID)
	AND		(RequestorUserID = @RequesteeUserID OR RequesteeUserID = @RequesteeUserID)
	
	
	IF @FriendshipRequestID IS NOT NULL
	BEGIN
	
		EXEC cs_FriendRequest_UpdateByID @FriendshipRequestID, @RequestorUserID, @RequesteeUserID, @Message, @FriendshipState
		RETURN 0;
	END
	ELSE
		RETURN 1;
END

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_FriendRequest_Update] to [public]
go
