IF OBJECT_ID(N'[dbo].[cs_FriendRequest_SelectByRequesteeUserID]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_SelectByRequesteeUserID]
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE [dbo].[cs_FriendRequest_SelectByRequesteeUserID]
(
	@UserID int, 
	@FriendshipState tinyint = NULL,
	@sortOrder int,
	@sortBy int,
	@pageIndex int,
        @pageSize int,
        @totalCount int output
)

AS


DECLARE @rowsToReturn int
DECLARE @pageLowerBound int
DECLARE @pageUpperBound int

-- Create temp table
CREATE TABLE #Temp
(
    IndexId int identity (1, 1) NOT NULL,
    FriendshipRequestID int NOT NULL,
    RequestorUserID int NOT NULL,
    RequesteeUserID int NOT NULL,
    FriendshipState tinyint NULL,
    [Message] nvarchar(2000) collate database_default NULL,
    CreatedDate datetime NULL,
    LastModifiedDate datetime NULL
)

IF (@sortBy = 0)
BEGIN

	IF (@sortOrder = 0)
	BEGIN

		INSERT INTO #Temp
			(FriendshipRequestID, RequestorUserID, RequesteeUserID, FriendshipState, [Message], CreatedDate, LastModifiedDate)
		SELECT		
			FriendshipRequestID, 
			RequestorUserID, 
			RequesteeUserID, 
			FriendshipState, 
			[Message], 
			CreatedDate, 
			LastModifiedDate
		FROM [dbo].[cs_FriendRequests]
		WHERE RequesteeUserID = @UserID
			AND	(@FriendshipState IS NULL OR FriendshipState = @FriendshipState)
		ORDER BY CreatedDate ASC

		SET @totalCount = @@ROWCOUNT

	END ELSE BEGIN

		INSERT INTO #Temp
			(FriendshipRequestID, RequestorUserID, RequesteeUserID, FriendshipState, [Message], CreatedDate, LastModifiedDate)
		SELECT		
			FriendshipRequestID, 
			RequestorUserID, 
			RequesteeUserID, 
			FriendshipState, 
			[Message], 
			CreatedDate, 
			LastModifiedDate
		FROM [dbo].[cs_FriendRequests]
		WHERE RequesteeUserID = @UserID
			AND	(@FriendshipState IS NULL OR FriendshipState = @FriendshipState)
		ORDER BY CreatedDate DESC

		SET @totalCount = @@ROWCOUNT

	END

END ELSE BEGIN

	IF (@sortOrder = 0)
	BEGIN

		INSERT INTO #Temp
			(FriendshipRequestID, RequestorUserID, RequesteeUserID, FriendshipState, [Message], CreatedDate, LastModifiedDate)
		SELECT		
			FriendshipRequestID, 
			RequestorUserID, 
			RequesteeUserID, 
			FriendshipState, 
			[Message], 
			CreatedDate, 
			LastModifiedDate
		FROM [dbo].[cs_FriendRequests]
		WHERE RequesteeUserID = @UserID
			AND	(@FriendshipState IS NULL OR FriendshipState = @FriendshipState)
		ORDER BY CreatedDate ASC

		SET @totalCount = @@ROWCOUNT

	END ELSE BEGIN

		INSERT INTO #Temp
			(FriendshipRequestID, RequestorUserID, RequesteeUserID, FriendshipState, [Message], CreatedDate, LastModifiedDate)
		SELECT		
			FriendshipRequestID, 
			RequestorUserID, 
			RequesteeUserID, 
			FriendshipState, 
			[Message], 
			CreatedDate, 
			LastModifiedDate
		FROM [dbo].[cs_FriendRequests]
		WHERE RequesteeUserID = @UserID
			AND	(@FriendshipState IS NULL OR FriendshipState = @FriendshipState)
		ORDER BY CreatedDate DESC

		SET @totalCount = @@ROWCOUNT

	END

END

-- Set the rowcount
SET @rowsToReturn = @pageSize * (@pageIndex + 1)
SET ROWCOUNT @rowsToReturn

-- Set the page bounds
SET @pageLowerBound = @pageSize * @pageIndex
SET @pageUpperBound = @pageLowerBound + @pageSize + 1

-- Select from temp table only the proper number of rows
SELECT FriendshipRequestID, RequestorUserID, RequesteeUserID, FriendshipState, [Message], CreatedDate, LastModifiedDate
FROM #Temp
WHERE #Temp.IndexId > @pageLowerBound
AND #Temp.IndexId <  @pageUpperBound

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_FriendRequest_SelectByRequesteeUserID] to [public]
go
