IF OBJECT_ID(N'[dbo].[cs_FriendRequest_SelectByID]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_SelectByID]

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE [dbo].[cs_FriendRequest_SelectByID]
(
	@FriendshipRequestID int
)

AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON;

BEGIN
	SELECT		
		FriendshipRequestID, 
		RequestorUserID, 
		RequesteeUserID, 
		FriendshipState, 
		Message, 
		CreatedDate, 
		LastModifiedDate
	FROM		[dbo].[cs_FriendRequests]
	WHERE		FriendshipRequestID = @FriendshipRequestID
	
	RETURN 0;			
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_FriendRequest_SelectByID] to [public]
go
