IF OBJECT_ID(N'[dbo].[cs_FriendRequest_SelectBetweenUsers]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_SelectBetweenUsers]

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE [dbo].[cs_FriendRequest_SelectBetweenUsers]
(
	@UserID1 int, 
	@UserID2 int
)

AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON;

BEGIN
	SELECT		
		FR.FriendshipRequestID, 
		FR.RequestorUserID, 
		FR.RequesteeUserID, 
		FR.FriendshipState, 
		FR.[Message], 
		FR.CreatedDate, 
		FR.LastModifiedDate
	FROM [dbo].[cs_FriendRequests] FR
	WHERE (FR.RequestorUserID = @UserID1 AND FR.RequesteeUserID = @UserID2)
	   OR (FR.RequesteeUserID = @UserID1 AND FR.RequestorUserID = @UserID2)
	
	RETURN 0;			
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_FriendRequest_SelectBetweenUsers] to [public]
go
