IF OBJECT_ID(N'[dbo].[cs_FriendRequest_Save]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_Save]

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE [dbo].[cs_FriendRequest_Save]
(
	@ID int,
	@RequestorUserID	int, 
	@RequesteeUserID	int, 
	@Message	varchar(2000), 
	@FriendshipState			tinyint,
	@FriendshipRequestID				int out
)

AS

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON;

BEGIN
IF @ID = 0
	BEGIN

	SELECT	@ID = ISNULL(FriendshipRequestID,0)
	FROM	[dbo].[cs_FriendRequests]
	WHERE	(RequestorUserID = @RequestorUserID OR RequesteeUserID = @RequestorUserID)
	AND		(RequestorUserID = @RequesteeUserID OR RequesteeUserID = @RequesteeUserID)
	
	END
	
	IF @ID = 0
	BEGIN
		EXEC cs_FriendRequest_Insert @RequestorUserID, @RequesteeUserID, @Message, @FriendshipState, @FriendshipRequestID out
	END
	ELSE
	BEGIN
		EXEC cs_FriendRequest_UpdateByID @ID, @RequestorUserID, @RequesteeUserID, @Message, @FriendshipState
		SET @FriendshipRequestID = @ID
	END
END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_FriendRequest_Save] to [public]
go
