IF OBJECT_ID(N'[dbo].[cs_FriendRequest_Insert]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_Insert]

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

CREATE PROCEDURE [dbo].[cs_FriendRequest_Insert]
(
	@RequestorUserID	int,
	@RequesteeUserID	int,
	@Message	varchar(2000),
	@FriendshipState			tinyint,
	@FriendshipRequestID				int out
)

AS
BEGIN

	SET Transaction Isolation Level Read UNCOMMITTED
	SET NOCOUNT ON;

	IF NOT EXISTS
	(
		SELECT 1 FROM [dbo].[cs_FriendRequests]
		WHERE	(RequestorUserID = @RequestorUserID	OR RequesteeUserID = @RequestorUserID)
			AND (RequestorUserID = @RequesteeUserID OR RequesteeUserID = @RequesteeUserID)
	)
	BEGIN

		INSERT INTO		[dbo].[cs_FriendRequests]
		(
			RequestorUserID,
			RequesteeUserID,
			Message,
			FriendshipState
		)
		VALUES
		(
			@RequestorUserID,
			@RequesteeUserID,
			@Message,
			@FriendshipState
		)

		SET @FriendshipRequestID = SCOPE_IDENTITY();

		EXECUTE [cs_FriendRequest_xref_Insert] @RequestorUserID, @RequesteeUserID, @FriendshipState

		RETURN 0;

	END ELSE BEGIN

		RETURN 1;

	END

END

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

grant execute on [dbo].[cs_FriendRequest_Insert] to [public]
go
