IF OBJECT_ID(N'[dbo].[cs_FriendRequest_DeleteByID]') IS NOT NULL
	DROP PROCEDURE [dbo].[cs_FriendRequest_DeleteByID]

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE [dbo].[cs_FriendRequest_DeleteByID]
( 
	@FriendshipRequestID int 
)

AS

SET NOCOUNT ON;

BEGIN
	DECLARE @UserID int, @FriendID int 	
	
	SELECT @UserID = RequestorUserID FROM [dbo].[cs_FriendRequests] WHERE FriendshipRequestID = @FriendshipRequestID
	SELECT @FriendID = RequesteeUserID FROM [dbo].[cs_FriendRequests] WHERE FriendshipRequestID = @FriendshipRequestID
	
	DELETE FROM	[dbo].[cs_FriendRequests]
	WHERE		FriendshipRequestID = @FriendshipRequestID

	DELETE FROM	[dbo].[cs_Friends_xref] 
	WHERE		UserID = @UserID AND FriendUserID = @FriendID
	
	DELETE FROM	[dbo].[cs_Friends_xref] 
	WHERE		UserID = @FriendID AND FriendUserID = @UserID	

	RETURN 0;

END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_FriendRequest_DeleteByID] to [public]
go
