SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_ConfigurableAddonData_CreateUpdate]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_ConfigurableAddonData_CreateUpdate]
GO

CREATE PROCEDURE dbo.cs_ConfigurableAddonData_CreateUpdate
	@AddonID uniqueidentifier,
	@SettingsID int,
	@AddonName varchar(255) = null,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null
AS

if exists(select AddonID from cs_AddonConfigurationData where AddonID = @AddonID and SettingsID = @SettingsID)
	begin
		update cs_AddonConfigurationData
		set 	AddonName = @AddonName,
			PropertyNames = @PropertyNames,
			PropertyValues = @PropertyValues
		where AddonID = @AddonID and SettingsID = @SettingsID
	end else begin
		insert into cs_AddonConfigurationData (AddonID, AddonName, SettingsID, PropertyNames, PropertyValues) 
		values (@AddonID, @AddonName, @SettingsID, @PropertyNames, @PropertyValues)
	end
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_ConfigurableAddonData_CreateUpdate]  TO [public]
GO

