SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Major int, @Minor int, @Patch int, @Installed DateTime, @Prereqs int

Set @Major = 4;
Set @Minor = 1;
Set @Patch = 27;

Select @Prereqs = isnull(Count(InstallDate),0)  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch<@Patch

Select @Installed = InstallDate  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch=@Patch

If(@Installed is null AND @Prereqs = @Patch)
	BEGIN
--## Schema Patch ##

IF OBJECT_ID('[dbo].[aspnet_AnyDataInTables]') IS NOT NULL
	EXECUTE sp_executesql N'GRANT EXECUTE ON [dbo].[aspnet_AnyDataInTables] TO [public]'

IF OBJECT_ID('[dbo].[aspnet_Applications_CreateApplication]') IS NOT NULL
	EXECUTE sp_executesql N'GRANT EXECUTE ON [dbo].[aspnet_Applications_CreateApplication] TO [public]'

IF OBJECT_ID('[dbo].[aspnet_Setup_RemoveAllRoleMembers]') IS NOT NULL
	EXECUTE sp_executesql N'GRANT EXECUTE ON [dbo].[aspnet_Setup_RemoveAllRoleMembers] TO [public]'

IF OBJECT_ID('[dbo].[aspnet_Setup_RestorePermissions]') IS NOT NULL
	EXECUTE sp_executesql N'GRANT EXECUTE ON [dbo].[aspnet_Setup_RestorePermissions] TO [public]'

IF OBJECT_ID('[dbo].[aspnet_Users_CreateUser]') IS NOT NULL
	EXECUTE sp_executesql N'GRANT EXECUTE ON [dbo].[aspnet_Users_CreateUser] TO [public]'

--## END Schema Patch ##
Insert into cs_SchemaVersion(Major, Minor, Patch, InstallDate) values (@Major, @Minor, @Patch, GetDate())

Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was applied successfully '

	END
ELSE IF(@Installed is not null)
	BEGIN
Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was already applied on ' + Convert(varchar(50), @Installed)  
	END 
ELSE
	BEGIN
Print 'The patch could not be applied because your current schema is missing previous updates (Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ')' 
	END