SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Major int, @Minor int, @Patch int, @Installed DateTime, @Prereqs int

Set @Major = 4;
Set @Minor = 1;
Set @Patch = 18;

Select @Prereqs = isnull(Count(InstallDate),0)  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch<@Patch

Select @Installed = InstallDate  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch=@Patch

If(@Installed is null AND @Prereqs = @Patch)
	BEGIN
--## Schema Patch ##


if object_id('FK_cs_Wiki_PageFollowers_PageId', 'F') is not null
	EXECUTE sp_executesql N'ALTER TABLE cs_Wiki_PageFollowers DROP CONSTRAINT FK_cs_Wiki_PageFollowers_PageId'

EXECUTE sp_executesql N'ALTER TABLE cs_Wiki_PageFollowers ADD CONSTRAINT
	FK_cs_Wiki_PageFollowers_PageId FOREIGN KEY
	(
	PageId
	) REFERENCES cs_Wiki_Pages
	(
	PageId
	)ON DELETE  CASCADE'

if object_id('FK_cs_Wiki_Permissions_WikiId', 'F') is not null
	EXECUTE sp_executesql N'ALTER TABLE cs_Wiki_Permissions DROP CONSTRAINT FK_cs_Wiki_Permissions_WikiId'

EXECUTE sp_executesql N'ALTER TABLE cs_Wiki_Permissions ADD CONSTRAINT
	FK_cs_Wiki_Permissions_WikiId FOREIGN KEY
	(
	WikiId
	) REFERENCES cs_Wiki_Wikis
	(
	WikiId
	)ON DELETE  CASCADE'


--## END Schema Patch ##
Insert into cs_SchemaVersion(Major, Minor, Patch, InstallDate) values (@Major, @Minor, @Patch, GetDate())

Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was applied successfully '

	END
ELSE IF(@Installed is not null)
	BEGIN
Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was already applied on ' + Convert(varchar(50), @Installed)  
	END 
ELSE
	BEGIN
Print 'The patch could not be applied because your current schema is missing previous updates (Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ')' 
	END 
