SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Major int, @Minor int, @Patch int, @Installed DateTime, @Prereqs int

Set @Major = 4;
Set @Minor = 1;
Set @Patch = 4;

Select @Prereqs = isnull(Count(InstallDate),0)  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch<@Patch

Select @Installed = InstallDate  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch=@Patch

If(@Installed is null AND @Prereqs = @Patch)
	BEGIN
--## Schema Patch ##


EXECUTE sp_executesql N'
ALTER TABLE [dbo].[cs_Wiki_Pages]
	ADD [RevisionCount] [int] NOT NULL CONSTRAINT [DF_cs_Wiki_Pages_RevisionCount]  DEFAULT ((1))'

EXECUTE sp_executesql N'
UPDATE [cs_Wiki_Pages] SET RevisionCount = 0'

EXECUTE sp_executesql N'
UPDATE [cs_Wiki_Pages] SET RevisionCount =
	(SELECT     COALESCE (COUNT(r.PageRevisionId), 0) AS cnt
	FROM          cs_Wiki_PageRevisions r
	WHERE r.PageId = [cs_Wiki_Pages].PageId)'
	
EXECUTE sp_executesql N'
UPDATE [cs_Wiki_Pages] SET RevisionCount = RevisionCount + 1'



--## END Schema Patch ##
Insert into cs_SchemaVersion(Major, Minor, Patch, InstallDate) values (@Major, @Minor, @Patch, GetDate())

Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was applied successfully '

	END
ELSE IF(@Installed is not null)
	BEGIN
Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was already applied on ' + Convert(varchar(50), @Installed)  
	END 
ELSE
	BEGIN
Print 'The patch could not be applied because your current schema is missing previous updates (Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ')' 
	END 
