SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Major int, @Minor int, @Patch int, @Installed DateTime, @Prereqs int

Set @Major = 4;
Set @Minor = 0;
Set @Patch = 2;

Select @Prereqs = isnull(Count(InstallDate),0)  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch<@Patch

Select @Installed = InstallDate  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch=@Patch

If(@Installed is null AND @Prereqs = @Patch)
	BEGIN

--## Schema Patch ##


if object_id('cs_TEMP_FoldSpamConfiguration', 'P') IS NOT NULL
	exec ('drop procedure cs_TEMP_FoldSpamConfiguration')

/* create temp stored proc */
exec('
create procedure cs_TEMP_FoldSpamConfiguration
	@SettingsID int
	, @xml ntext = null
as

declare @ret int, @iXml int, @node nvarchar(128)

select @node = N''/SpamConfiguration/RuleSettings/RuleSetting''

EXECUTE @ret = [master].[dbo].[sp_xml_preparedocument] @iXml OUTPUT, @xml

declare @t table (
	[parentid] int not null
	, [id] int not null
	, [RuleID] uniqueidentifier not null
	, [Key] nvarchar(128) collate database_default not null
	, [Value] nvarchar(3875) collate database_default not null
	, [ValueLength] int not null
)

insert into @t
SELECT
	n.[parentid]
	, n.[id]
	, r.[RuleID]
    , n.[localname] [Key]
    , d.[text] [value]
    , datalength(d.[text]) / 2 [value_len] FROM (
	SELECT * FROM OPENXML(@iXml, @node, 2)
	with (
		[RuleID] uniqueidentifier ''RuleID/text()''
		, [id] int ''@mp:id''
	)
) AS r
inner join (
	SELECT [id], [parentid], [localname] FROM OPENXML(@iXml, @node, 2)
) as n on n.[parentid] = r.[id]
inner join (
	SELECT [parentid], [text] FROM OPENXML(@iXml, @node, 2)
) as d on d.[parentid] = n.[id]
where
	n.[localname] <> N''RuleID'' and n.[localname] <> ''Description'' and 
	n.[localname] <> ''MaxValueLength'' and n.[localname] <> ''DefaultValue''
order by
	n.[parentid], n.[id]

/* release the XML document now that we are done */
EXECUTE [master].[dbo].[sp_xml_removedocument] @iXml

declare @p table (
	[id] int identity(1, 1) not null
	, [AddonID] uniqueidentifier not null
	, [PropertyName] nvarchar(128) collate database_default null
	, [PropertyValue] nvarchar(3875) collate database_default null
)

insert into @p (AddonID, PropertyName, PropertyValue)
select RuleID [AddonID]
	, [Value] + N'':S:'' + coalesce((
		select cast(sum(tx.[ValueLength]) as nvarchar) from @t tx
		where tx.[Key] = ''Value'' and tx.[id] < t.[id] and tx.[RuleID] = t.[RuleID]
	), N''0'') + N'':'' + coalesce((select cast(sum(tx.[ValueLength]) as nvarchar) from @t tx 
		where tx.[parentid] = t.[parentid] and tx.[Key] = ''Value''), N''0'') + N'':'' [PropertyName]
	, (select tx.[Value] from @t tx where tx.[parentid] = t.[parentid] and tx.[Key] = ''Value'') [PropertyValue]
from @t t
where t.[Key] = ''Key''
order by
	t.[RuleID]

if object_id(''tempdb..#flat'') IS NOT NULL exec (''drop table #flat'')

create table #flat (
	[AddonID] uniqueidentifier not null
	, [PropertyNames] ntext collate database_default null
	, [PropertyValues] ntext collate database_default null
)

declare @id int, @AddonID uniqueidentifier
	, @PropertyName nvarchar(128), @PropertyValue nvarchar(3875)
	, @pnPTR binary(16), @pvPTR binary(16)

select @id = 1

while 1=1
begin
	select
		@AddonID = p.[AddonID], @PropertyName = p.[PropertyName], @PropertyValue = p.[PropertyValue]
	from @p p
	where p.[id] = @id
	
	if @@ROWCOUNT = 0 break
	
	if not exists (select 1 from #flat where [AddonID] = @AddonID)
		insert into #flat ([AddonID], [PropertyNames], [PropertyValues]) values (@AddonID, '''', '''')
	
	select @pnPTR = TEXTPTR(f.[PropertyNames]), @pvPTR = TEXTPTR(f.[PropertyValues])
	from #flat f
	where f.[AddonID] = @AddonID
	
	updatetext #flat.[PropertyNames]  @pnPTR null 0 @PropertyName
	updatetext #flat.[PropertyValues] @pvPTR null 0 @PropertyValue
	
	select @id = @id + 1
end

/* showing what was migrated */
select
	cast( f.AddonID as nvarchar(255) )
	, @SettingsID
	, f.AddonID, f.PropertyNames, f.PropertyValues
from
	#flat f
where
	not exists (
		select 1 from [cs_AddonConfigurationData] fx
		where fx.[SettingsID] = @SettingsID AND cast( f.AddonID as nvarchar(255) ) = fx.[AddonName]
	)

/* actually setting it */
INSERT INTO [cs_AddonConfigurationData]( [AddonName], [SettingsID], [AddonID], [PropertyNames], [PropertyValues] )
select
	cast( f.AddonID as nvarchar(255) )
	, @SettingsID
	, f.AddonID, f.PropertyNames, f.PropertyValues
from
	#flat f
where
	not exists (
		select 1 from [cs_AddonConfigurationData] fx
		where fx.[SettingsID] = @SettingsID AND cast( f.AddonID as nvarchar(255) ) = fx.[AddonName]
	)

drop table #flat
')

/* execute rehash - designed to work with sql 2k and 2k5 */
exec (N'
	set nocount on

	declare @qPosition int,
		@qValue nvarchar(4000),
		@hasErrorOccured bit

	/* declare 250 nvarchar(4000) (nearly 1MB worth of space) */
	declare @q1 nvarchar(4000), @q2 nvarchar(4000), @q3 nvarchar(4000), @q4 nvarchar(4000), @q5 nvarchar(4000), @q6 nvarchar(4000), @q7 nvarchar(4000), @q8 nvarchar(4000), @q9 nvarchar(4000), @q10 nvarchar(4000), 
		@q11 nvarchar(4000), @q12 nvarchar(4000), @q13 nvarchar(4000), @q14 nvarchar(4000), @q15 nvarchar(4000), @q16 nvarchar(4000), @q17 nvarchar(4000), @q18 nvarchar(4000), @q19 nvarchar(4000), @q20 nvarchar(4000), 
		@q21 nvarchar(4000), @q22 nvarchar(4000), @q23 nvarchar(4000), @q24 nvarchar(4000), @q25 nvarchar(4000), @q26 nvarchar(4000), @q27 nvarchar(4000), @q28 nvarchar(4000), @q29 nvarchar(4000), @q30 nvarchar(4000), 
		@q31 nvarchar(4000), @q32 nvarchar(4000), @q33 nvarchar(4000), @q34 nvarchar(4000), @q35 nvarchar(4000), @q36 nvarchar(4000), @q37 nvarchar(4000), @q38 nvarchar(4000), @q39 nvarchar(4000), @q40 nvarchar(4000), 
		@q41 nvarchar(4000), @q42 nvarchar(4000), @q43 nvarchar(4000), @q44 nvarchar(4000), @q45 nvarchar(4000), @q46 nvarchar(4000), @q47 nvarchar(4000), @q48 nvarchar(4000), @q49 nvarchar(4000), @q50 nvarchar(4000), 
		@q51 nvarchar(4000), @q52 nvarchar(4000), @q53 nvarchar(4000), @q54 nvarchar(4000), @q55 nvarchar(4000), @q56 nvarchar(4000), @q57 nvarchar(4000), @q58 nvarchar(4000), @q59 nvarchar(4000), @q60 nvarchar(4000), 
		@q61 nvarchar(4000), @q62 nvarchar(4000), @q63 nvarchar(4000), @q64 nvarchar(4000), @q65 nvarchar(4000), @q66 nvarchar(4000), @q67 nvarchar(4000), @q68 nvarchar(4000), @q69 nvarchar(4000), @q70 nvarchar(4000), 
		@q71 nvarchar(4000), @q72 nvarchar(4000), @q73 nvarchar(4000), @q74 nvarchar(4000), @q75 nvarchar(4000), @q76 nvarchar(4000), @q77 nvarchar(4000), @q78 nvarchar(4000), @q79 nvarchar(4000), @q80 nvarchar(4000), 
		@q81 nvarchar(4000), @q82 nvarchar(4000), @q83 nvarchar(4000), @q84 nvarchar(4000), @q85 nvarchar(4000), @q86 nvarchar(4000), @q87 nvarchar(4000), @q88 nvarchar(4000), @q89 nvarchar(4000), @q90 nvarchar(4000), 
		@q91 nvarchar(4000), @q92 nvarchar(4000), @q93 nvarchar(4000), @q94 nvarchar(4000), @q95 nvarchar(4000), @q96 nvarchar(4000), @q97 nvarchar(4000), @q98 nvarchar(4000), @q99 nvarchar(4000), @q100 nvarchar(4000), 
		@q101 nvarchar(4000), @q102 nvarchar(4000), @q103 nvarchar(4000), @q104 nvarchar(4000), @q105 nvarchar(4000), @q106 nvarchar(4000), @q107 nvarchar(4000), @q108 nvarchar(4000), @q109 nvarchar(4000), @q110 nvarchar(4000), 
		@q111 nvarchar(4000), @q112 nvarchar(4000), @q113 nvarchar(4000), @q114 nvarchar(4000), @q115 nvarchar(4000), @q116 nvarchar(4000), @q117 nvarchar(4000), @q118 nvarchar(4000), @q119 nvarchar(4000), @q120 nvarchar(4000), 
		@q121 nvarchar(4000), @q122 nvarchar(4000), @q123 nvarchar(4000), @q124 nvarchar(4000), @q125 nvarchar(4000), @q126 nvarchar(4000), @q127 nvarchar(4000), @q128 nvarchar(4000), @q129 nvarchar(4000), @q130 nvarchar(4000), 
		@q131 nvarchar(4000), @q132 nvarchar(4000), @q133 nvarchar(4000), @q134 nvarchar(4000), @q135 nvarchar(4000), @q136 nvarchar(4000), @q137 nvarchar(4000), @q138 nvarchar(4000), @q139 nvarchar(4000), @q140 nvarchar(4000), 
		@q141 nvarchar(4000), @q142 nvarchar(4000), @q143 nvarchar(4000), @q144 nvarchar(4000), @q145 nvarchar(4000), @q146 nvarchar(4000), @q147 nvarchar(4000), @q148 nvarchar(4000), @q149 nvarchar(4000), @q150 nvarchar(4000), 
		@q151 nvarchar(4000), @q152 nvarchar(4000), @q153 nvarchar(4000), @q154 nvarchar(4000), @q155 nvarchar(4000), @q156 nvarchar(4000), @q157 nvarchar(4000), @q158 nvarchar(4000), @q159 nvarchar(4000), @q160 nvarchar(4000), 
		@q161 nvarchar(4000), @q162 nvarchar(4000), @q163 nvarchar(4000), @q164 nvarchar(4000), @q165 nvarchar(4000), @q166 nvarchar(4000), @q167 nvarchar(4000), @q168 nvarchar(4000), @q169 nvarchar(4000), @q170 nvarchar(4000), 
		@q171 nvarchar(4000), @q172 nvarchar(4000), @q173 nvarchar(4000), @q174 nvarchar(4000), @q175 nvarchar(4000), @q176 nvarchar(4000), @q177 nvarchar(4000), @q178 nvarchar(4000), @q179 nvarchar(4000), @q180 nvarchar(4000), 
		@q181 nvarchar(4000), @q182 nvarchar(4000), @q183 nvarchar(4000), @q184 nvarchar(4000), @q185 nvarchar(4000), @q186 nvarchar(4000), @q187 nvarchar(4000), @q188 nvarchar(4000), @q189 nvarchar(4000), @q190 nvarchar(4000), 
		@q191 nvarchar(4000), @q192 nvarchar(4000), @q193 nvarchar(4000), @q194 nvarchar(4000), @q195 nvarchar(4000), @q196 nvarchar(4000), @q197 nvarchar(4000), @q198 nvarchar(4000), @q199 nvarchar(4000), @q200 nvarchar(4000), 
		@q201 nvarchar(4000), @q202 nvarchar(4000), @q203 nvarchar(4000), @q204 nvarchar(4000), @q205 nvarchar(4000), @q206 nvarchar(4000), @q207 nvarchar(4000), @q208 nvarchar(4000), @q209 nvarchar(4000), @q210 nvarchar(4000), 
		@q211 nvarchar(4000), @q212 nvarchar(4000), @q213 nvarchar(4000), @q214 nvarchar(4000), @q215 nvarchar(4000), @q216 nvarchar(4000), @q217 nvarchar(4000), @q218 nvarchar(4000), @q219 nvarchar(4000), @q220 nvarchar(4000), 
		@q221 nvarchar(4000), @q222 nvarchar(4000), @q223 nvarchar(4000), @q224 nvarchar(4000), @q225 nvarchar(4000), @q226 nvarchar(4000), @q227 nvarchar(4000), @q228 nvarchar(4000), @q229 nvarchar(4000), @q230 nvarchar(4000), 
		@q231 nvarchar(4000), @q232 nvarchar(4000), @q233 nvarchar(4000), @q234 nvarchar(4000), @q235 nvarchar(4000), @q236 nvarchar(4000), @q237 nvarchar(4000), @q238 nvarchar(4000), @q239 nvarchar(4000), @q240 nvarchar(4000), 
		@q241 nvarchar(4000), @q242 nvarchar(4000), @q243 nvarchar(4000), @q244 nvarchar(4000), @q245 nvarchar(4000), @q246 nvarchar(4000), @q247 nvarchar(4000), @q248 nvarchar(4000), @q249 nvarchar(4000), @q250 nvarchar(3999),
		@q251 nvarchar(1)

	/* initialize all vars */
	select @q1 = N'''', @q2 = N'''', @q3 = N'''', @q4 = N'''', @q5 = N'''', @q6 = N'''', @q7 = N'''', @q8 = N'''', @q9 = N'''', @q10 = N'''', 
		@q11 = N'''', @q12 = N'''', @q13 = N'''', @q14 = N'''', @q15 = N'''', @q16 = N'''', @q17 = N'''', @q18 = N'''', @q19 = N'''', @q20 = N'''', 
		@q21 = N'''', @q22 = N'''', @q23 = N'''', @q24 = N'''', @q25 = N'''', @q26 = N'''', @q27 = N'''', @q28 = N'''', @q29 = N'''', @q30 = N'''', 
		@q31 = N'''', @q32 = N'''', @q33 = N'''', @q34 = N'''', @q35 = N'''', @q36 = N'''', @q37 = N'''', @q38 = N'''', @q39 = N'''', @q40 = N'''', 
		@q41 = N'''', @q42 = N'''', @q43 = N'''', @q44 = N'''', @q45 = N'''', @q46 = N'''', @q47 = N'''', @q48 = N'''', @q49 = N'''', @q50 = N'''', 
		@q51 = N'''', @q52 = N'''', @q53 = N'''', @q54 = N'''', @q55 = N'''', @q56 = N'''', @q57 = N'''', @q58 = N'''', @q59 = N'''', @q60 = N'''', 
		@q61 = N'''', @q62 = N'''', @q63 = N'''', @q64 = N'''', @q65 = N'''', @q66 = N'''', @q67 = N'''', @q68 = N'''', @q69 = N'''', @q70 = N'''', 
		@q71 = N'''', @q72 = N'''', @q73 = N'''', @q74 = N'''', @q75 = N'''', @q76 = N'''', @q77 = N'''', @q78 = N'''', @q79 = N'''', @q80 = N'''', 
		@q81 = N'''', @q82 = N'''', @q83 = N'''', @q84 = N'''', @q85 = N'''', @q86 = N'''', @q87 = N'''', @q88 = N'''', @q89 = N'''', @q90 = N'''', 
		@q91 = N'''', @q92 = N'''', @q93 = N'''', @q94 = N'''', @q95 = N'''', @q96 = N'''', @q97 = N'''', @q98 = N'''', @q99 = N'''', @q100 = N'''', 
		@q101 = N'''', @q102 = N'''', @q103 = N'''', @q104 = N'''', @q105 = N'''', @q106 = N'''', @q107 = N'''', @q108 = N'''', @q109 = N'''', @q110 = N'''', 
		@q111 = N'''', @q112 = N'''', @q113 = N'''', @q114 = N'''', @q115 = N'''', @q116 = N'''', @q117 = N'''', @q118 = N'''', @q119 = N'''', @q120 = N'''', 
		@q121 = N'''', @q122 = N'''', @q123 = N'''', @q124 = N'''', @q125 = N'''', @q126 = N'''', @q127 = N'''', @q128 = N'''', @q129 = N'''', @q130 = N'''', 
		@q131 = N'''', @q132 = N'''', @q133 = N'''', @q134 = N'''', @q135 = N'''', @q136 = N'''', @q137 = N'''', @q138 = N'''', @q139 = N'''', @q140 = N'''', 
		@q141 = N'''', @q142 = N'''', @q143 = N'''', @q144 = N'''', @q145 = N'''', @q146 = N'''', @q147 = N'''', @q148 = N'''', @q149 = N'''', @q150 = N'''', 
		@q151 = N'''', @q152 = N'''', @q153 = N'''', @q154 = N'''', @q155 = N'''', @q156 = N'''', @q157 = N'''', @q158 = N'''', @q159 = N'''', @q160 = N'''', 
		@q161 = N'''', @q162 = N'''', @q163 = N'''', @q164 = N'''', @q165 = N'''', @q166 = N'''', @q167 = N'''', @q168 = N'''', @q169 = N'''', @q170 = N'''', 
		@q171 = N'''', @q172 = N'''', @q173 = N'''', @q174 = N'''', @q175 = N'''', @q176 = N'''', @q177 = N'''', @q178 = N'''', @q179 = N'''', @q180 = N'''', 
		@q181 = N'''', @q182 = N'''', @q183 = N'''', @q184 = N'''', @q185 = N'''', @q186 = N'''', @q187 = N'''', @q188 = N'''', @q189 = N'''', @q190 = N'''', 
		@q191 = N'''', @q192 = N'''', @q193 = N'''', @q194 = N'''', @q195 = N'''', @q196 = N'''', @q197 = N'''', @q198 = N'''', @q199 = N'''', @q200 = N'''', 
		@q201 = N'''', @q202 = N'''', @q203 = N'''', @q204 = N'''', @q205 = N'''', @q206 = N'''', @q207 = N'''', @q208 = N'''', @q209 = N'''', @q210 = N'''', 
		@q211 = N'''', @q212 = N'''', @q213 = N'''', @q214 = N'''', @q215 = N'''', @q216 = N'''', @q217 = N'''', @q218 = N'''', @q219 = N'''', @q220 = N'''', 
		@q221 = N'''', @q222 = N'''', @q223 = N'''', @q224 = N'''', @q225 = N'''', @q226 = N'''', @q227 = N'''', @q228 = N'''', @q229 = N'''', @q230 = N'''', 
		@q231 = N'''', @q232 = N'''', @q233 = N'''', @q234 = N'''', @q235 = N'''', @q236 = N'''', @q237 = N'''', @q238 = N'''', @q239 = N'''', @q240 = N'''', 
		@q241 = N'''', @q242 = N'''', @q243 = N'''', @q244 = N'''', @q245 = N'''', @q246 = N'''', @q247 = N'''', @q248 = N'''', @q249 = N'''', @q250 = N'''',
		@q251 = N'''''''' /* special ending for this process */

	select @qPosition = 1, @qValue = N'''', @hasErrorOccured = 0

	declare @SettingsID int, @sqlPTR binary(16), @sqlstring nvarchar(100), @index int
	select @index = 1
	DECLARE cSettingIDs CURSOR FOR
		SELECT acs.SettingsID from cs_ApplicationConfigurationSettings acs where acs.ApplicationType = 10

	open cSettingIDs
	fetch next from cSettingIDs into @SettingsID
	while @@fetch_status = 0
	begin
		set @q1 = N''exec cs_TEMP_FoldSpamConfiguration '' + cast(@SettingsID as nvarchar(10)) + N'', N''''''

		while @index <= 0x7ffffff
		begin
			select @qPosition = @qPosition + 1
			SELECT @qValue = (select replace( substring(acs.Settings, @index, 2000), N'''''''', N'''''''''''' )
				from cs_ApplicationConfigurationSettings acs where acs.SettingsID = @SettingsID AND acs.ApplicationType = 10)

			if @qValue is null OR datalength(@qValue) = 0 begin break end

			if @qPosition <= 100
			begin
				if @qPosition = 1 select @q1 = @qValue else if @qPosition = 2 select @q2 = @qValue else if @qPosition = 3 select @q3 = @qValue else if @qPosition = 4 select @q4 = @qValue else if @qPosition = 5 select @q5 = @qValue else if @qPosition = 6 select @q6 = @qValue else if @qPosition = 7 select @q7 = @qValue else if @qPosition = 8 select @q8 = @qValue else if @qPosition = 9 select @q9 = @qValue else if @qPosition = 10 select @q10 = @qValue 
				else if @qPosition = 11 select @q11 = @qValue else if @qPosition = 12 select @q12 = @qValue else if @qPosition = 13 select @q13 = @qValue else if @qPosition = 14 select @q14 = @qValue else if @qPosition = 15 select @q15 = @qValue else if @qPosition = 16 select @q16 = @qValue else if @qPosition = 17 select @q17 = @qValue else if @qPosition = 18 select @q18 = @qValue else if @qPosition = 19 select @q19 = @qValue else if @qPosition = 20 select @q20 = @qValue 
				else if @qPosition = 21 select @q21 = @qValue else if @qPosition = 22 select @q22 = @qValue else if @qPosition = 23 select @q23 = @qValue else if @qPosition = 24 select @q24 = @qValue else if @qPosition = 25 select @q25 = @qValue else if @qPosition = 26 select @q26 = @qValue else if @qPosition = 27 select @q27 = @qValue else if @qPosition = 28 select @q28 = @qValue else if @qPosition = 29 select @q29 = @qValue else if @qPosition = 30 select @q30 = @qValue 
				else if @qPosition = 31 select @q31 = @qValue else if @qPosition = 32 select @q32 = @qValue else if @qPosition = 33 select @q33 = @qValue else if @qPosition = 34 select @q34 = @qValue else if @qPosition = 35 select @q35 = @qValue else if @qPosition = 36 select @q36 = @qValue else if @qPosition = 37 select @q37 = @qValue else if @qPosition = 38 select @q38 = @qValue else if @qPosition = 39 select @q39 = @qValue else if @qPosition = 40 select @q40 = @qValue 
				else if @qPosition = 41 select @q41 = @qValue else if @qPosition = 42 select @q42 = @qValue else if @qPosition = 43 select @q43 = @qValue else if @qPosition = 44 select @q44 = @qValue else if @qPosition = 45 select @q45 = @qValue else if @qPosition = 46 select @q46 = @qValue else if @qPosition = 47 select @q47 = @qValue else if @qPosition = 48 select @q48 = @qValue else if @qPosition = 49 select @q49 = @qValue else if @qPosition = 50 select @q50 = @qValue 
				else if @qPosition = 51 select @q51 = @qValue else if @qPosition = 52 select @q52 = @qValue else if @qPosition = 53 select @q53 = @qValue else if @qPosition = 54 select @q54 = @qValue else if @qPosition = 55 select @q55 = @qValue else if @qPosition = 56 select @q56 = @qValue else if @qPosition = 57 select @q57 = @qValue else if @qPosition = 58 select @q58 = @qValue else if @qPosition = 59 select @q59 = @qValue else if @qPosition = 60 select @q60 = @qValue 
				else if @qPosition = 61 select @q61 = @qValue else if @qPosition = 62 select @q62 = @qValue else if @qPosition = 63 select @q63 = @qValue else if @qPosition = 64 select @q64 = @qValue else if @qPosition = 65 select @q65 = @qValue else if @qPosition = 66 select @q66 = @qValue else if @qPosition = 67 select @q67 = @qValue else if @qPosition = 68 select @q68 = @qValue else if @qPosition = 69 select @q69 = @qValue else if @qPosition = 70 select @q70 = @qValue 
				else if @qPosition = 71 select @q71 = @qValue else if @qPosition = 72 select @q72 = @qValue else if @qPosition = 73 select @q73 = @qValue else if @qPosition = 74 select @q74 = @qValue else if @qPosition = 75 select @q75 = @qValue else if @qPosition = 76 select @q76 = @qValue else if @qPosition = 77 select @q77 = @qValue else if @qPosition = 78 select @q78 = @qValue else if @qPosition = 79 select @q79 = @qValue else if @qPosition = 80 select @q80 = @qValue 
				else if @qPosition = 81 select @q81 = @qValue else if @qPosition = 82 select @q82 = @qValue else if @qPosition = 83 select @q83 = @qValue else if @qPosition = 84 select @q84 = @qValue else if @qPosition = 85 select @q85 = @qValue else if @qPosition = 86 select @q86 = @qValue else if @qPosition = 87 select @q87 = @qValue else if @qPosition = 88 select @q88 = @qValue else if @qPosition = 89 select @q89 = @qValue else if @qPosition = 90 select @q90 = @qValue 
				else if @qPosition = 91 select @q91 = @qValue else if @qPosition = 92 select @q92 = @qValue else if @qPosition = 93 select @q93 = @qValue else if @qPosition = 94 select @q94 = @qValue else if @qPosition = 95 select @q95 = @qValue else if @qPosition = 96 select @q96 = @qValue else if @qPosition = 97 select @q97 = @qValue else if @qPosition = 98 select @q98 = @qValue else if @qPosition = 99 select @q99 = @qValue else if @qPosition = 100 select @q100 = @qValue
			end
			else if @qPosition <= 200
			begin
				if @qPosition = 101 select @q101 = @qValue else if @qPosition = 102 select @q102 = @qValue else if @qPosition = 103 select @q103 = @qValue else if @qPosition = 104 select @q104 = @qValue else if @qPosition = 105 select @q105 = @qValue else if @qPosition = 106 select @q106 = @qValue else if @qPosition = 107 select @q107 = @qValue else if @qPosition = 108 select @q108 = @qValue else if @qPosition = 109 select @q109 = @qValue else if @qPosition = 110 select @q110 = @qValue
				else if @qPosition = 111 select @q111 = @qValue else if @qPosition = 112 select @q112 = @qValue else if @qPosition = 113 select @q113 = @qValue else if @qPosition = 114 select @q114 = @qValue else if @qPosition = 115 select @q115 = @qValue else if @qPosition = 116 select @q116 = @qValue else if @qPosition = 117 select @q117 = @qValue else if @qPosition = 118 select @q118 = @qValue else if @qPosition = 119 select @q119 = @qValue else if @qPosition = 120 select @q120 = @qValue
				else if @qPosition = 121 select @q121 = @qValue else if @qPosition = 122 select @q122 = @qValue else if @qPosition = 123 select @q123 = @qValue else if @qPosition = 124 select @q124 = @qValue else if @qPosition = 125 select @q125 = @qValue else if @qPosition = 126 select @q126 = @qValue else if @qPosition = 127 select @q127 = @qValue else if @qPosition = 128 select @q128 = @qValue else if @qPosition = 129 select @q129 = @qValue else if @qPosition = 130 select @q130 = @qValue 
				else if @qPosition = 131 select @q131 = @qValue else if @qPosition = 132 select @q132 = @qValue else if @qPosition = 133 select @q133 = @qValue else if @qPosition = 134 select @q134 = @qValue else if @qPosition = 135 select @q135 = @qValue else if @qPosition = 136 select @q136 = @qValue else if @qPosition = 137 select @q137 = @qValue else if @qPosition = 138 select @q138 = @qValue else if @qPosition = 139 select @q139 = @qValue else if @qPosition = 140 select @q140 = @qValue 
				else if @qPosition = 141 select @q141 = @qValue else if @qPosition = 142 select @q142 = @qValue else if @qPosition = 143 select @q143 = @qValue else if @qPosition = 144 select @q144 = @qValue else if @qPosition = 145 select @q145 = @qValue else if @qPosition = 146 select @q146 = @qValue else if @qPosition = 147 select @q147 = @qValue else if @qPosition = 148 select @q148 = @qValue else if @qPosition = 149 select @q149 = @qValue else if @qPosition = 150 select @q150 = @qValue 
				else if @qPosition = 151 select @q151 = @qValue else if @qPosition = 152 select @q152 = @qValue else if @qPosition = 153 select @q153 = @qValue else if @qPosition = 154 select @q154 = @qValue else if @qPosition = 155 select @q155 = @qValue else if @qPosition = 156 select @q156 = @qValue else if @qPosition = 157 select @q157 = @qValue else if @qPosition = 158 select @q158 = @qValue else if @qPosition = 159 select @q159 = @qValue else if @qPosition = 160 select @q160 = @qValue 
				else if @qPosition = 161 select @q161 = @qValue else if @qPosition = 162 select @q162 = @qValue else if @qPosition = 163 select @q163 = @qValue else if @qPosition = 164 select @q164 = @qValue else if @qPosition = 165 select @q165 = @qValue else if @qPosition = 166 select @q166 = @qValue else if @qPosition = 167 select @q167 = @qValue else if @qPosition = 168 select @q168 = @qValue else if @qPosition = 169 select @q169 = @qValue else if @qPosition = 170 select @q170 = @qValue 
				else if @qPosition = 171 select @q171 = @qValue else if @qPosition = 172 select @q172 = @qValue else if @qPosition = 173 select @q173 = @qValue else if @qPosition = 174 select @q174 = @qValue else if @qPosition = 175 select @q175 = @qValue else if @qPosition = 176 select @q176 = @qValue else if @qPosition = 177 select @q177 = @qValue else if @qPosition = 178 select @q178 = @qValue else if @qPosition = 179 select @q179 = @qValue else if @qPosition = 180 select @q180 = @qValue 
				else if @qPosition = 181 select @q181 = @qValue else if @qPosition = 182 select @q182 = @qValue else if @qPosition = 183 select @q183 = @qValue else if @qPosition = 184 select @q184 = @qValue else if @qPosition = 185 select @q185 = @qValue else if @qPosition = 186 select @q186 = @qValue else if @qPosition = 187 select @q187 = @qValue else if @qPosition = 188 select @q188 = @qValue else if @qPosition = 189 select @q189 = @qValue else if @qPosition = 190 select @q190 = @qValue 
				else if @qPosition = 191 select @q191 = @qValue else if @qPosition = 192 select @q192 = @qValue else if @qPosition = 193 select @q193 = @qValue else if @qPosition = 194 select @q194 = @qValue else if @qPosition = 195 select @q195 = @qValue else if @qPosition = 196 select @q196 = @qValue else if @qPosition = 197 select @q197 = @qValue else if @qPosition = 198 select @q198 = @qValue else if @qPosition = 199 select @q199 = @qValue else if @qPosition = 200 select @q200 = @qValue
			end else begin
				if @qPosition = 201 select @q201 = @qValue else if @qPosition = 202 select @q202 = @qValue else if @qPosition = 203 select @q203 = @qValue else if @qPosition = 204 select @q204 = @qValue else if @qPosition = 205 select @q205 = @qValue else if @qPosition = 206 select @q206 = @qValue else if @qPosition = 207 select @q207 = @qValue else if @qPosition = 208 select @q208 = @qValue else if @qPosition = 209 select @q209 = @qValue else if @qPosition = 210 select @q210 = @qValue 
				else if @qPosition = 211 select @q211 = @qValue else if @qPosition = 212 select @q212 = @qValue else if @qPosition = 213 select @q213 = @qValue else if @qPosition = 214 select @q214 = @qValue else if @qPosition = 215 select @q215 = @qValue else if @qPosition = 216 select @q216 = @qValue else if @qPosition = 217 select @q217 = @qValue else if @qPosition = 218 select @q218 = @qValue else if @qPosition = 219 select @q219 = @qValue else if @qPosition = 220 select @q220 = @qValue 
				else if @qPosition = 221 select @q221 = @qValue else if @qPosition = 222 select @q222 = @qValue else if @qPosition = 223 select @q223 = @qValue else if @qPosition = 224 select @q224 = @qValue else if @qPosition = 225 select @q225 = @qValue else if @qPosition = 226 select @q226 = @qValue else if @qPosition = 227 select @q227 = @qValue else if @qPosition = 228 select @q228 = @qValue else if @qPosition = 229 select @q229 = @qValue else if @qPosition = 230 select @q230 = @qValue 
				else if @qPosition = 231 select @q231 = @qValue else if @qPosition = 232 select @q232 = @qValue else if @qPosition = 233 select @q233 = @qValue else if @qPosition = 234 select @q234 = @qValue else if @qPosition = 235 select @q235 = @qValue else if @qPosition = 236 select @q236 = @qValue else if @qPosition = 237 select @q237 = @qValue else if @qPosition = 238 select @q238 = @qValue else if @qPosition = 239 select @q239 = @qValue else if @qPosition = 240 select @q240 = @qValue 
				else if @qPosition = 241 select @q241 = @qValue else if @qPosition = 242 select @q242 = @qValue else if @qPosition = 243 select @q243 = @qValue else if @qPosition = 244 select @q244 = @qValue else if @qPosition = 245 select @q245 = @qValue else if @qPosition = 246 select @q246 = @qValue else if @qPosition = 247 select @q247 = @qValue else if @qPosition = 248 select @q248 = @qValue else if @qPosition = 249 select @q249 = @qValue else if @qPosition = 250 select @q250 = @qValue
				
				if @qPosition > 250
				begin
					raiserror(''Internal Error : Command buffer limit of ~1MB has been reached! Resultset will not be executed.'', 16, -1)
					select @hasErrorOccured = 1
				end
			end

			if @hasErrorOccured = 1 begin break end

			select @index = @index + 2000, @qValue = null
		end

		if @hasErrorOccured = 1 begin break end

		/* concat all buffers and execute */
		exec(@q1+@q2+@q3+@q4+@q5+@q6+@q7+@q8+@q9+@q10+
			@q11+@q12+@q13+@q14+@q15+@q16+@q17+@q18+@q19+@q20+
			@q21+@q22+@q23+@q24+@q25+@q26+@q27+@q28+@q29+@q30+
			@q31+@q32+@q33+@q34+@q35+@q36+@q37+@q38+@q39+@q40+
			@q41+@q42+@q43+@q44+@q45+@q46+@q47+@q48+@q49+@q50+
			@q51+@q52+@q53+@q54+@q55+@q56+@q57+@q58+@q59+@q60+
			@q61+@q62+@q63+@q64+@q65+@q66+@q67+@q68+@q69+@q70+
			@q71+@q72+@q73+@q74+@q75+@q76+@q77+@q78+@q79+@q80+
			@q81+@q82+@q83+@q84+@q85+@q86+@q87+@q88+@q89+@q90+
			@q91+@q92+@q93+@q94+@q95+@q96+@q97+@q98+@q99+@q100+
			@q101+@q102+@q103+@q104+@q105+@q106+@q107+@q108+@q109+@q110+
			@q111+@q112+@q113+@q114+@q115+@q116+@q117+@q118+@q119+@q120+
			@q121+@q122+@q123+@q124+@q125+@q126+@q127+@q128+@q129+@q130+
			@q131+@q132+@q133+@q134+@q135+@q136+@q137+@q138+@q139+@q140+
			@q141+@q142+@q143+@q144+@q145+@q146+@q147+@q148+@q149+@q150+
			@q151+@q152+@q153+@q154+@q155+@q156+@q157+@q158+@q159+@q160+
			@q161+@q162+@q163+@q164+@q165+@q166+@q167+@q168+@q169+@q170+
			@q171+@q172+@q173+@q174+@q175+@q176+@q177+@q178+@q179+@q180+
			@q181+@q182+@q183+@q184+@q185+@q186+@q187+@q188+@q189+@q190+
			@q191+@q192+@q193+@q194+@q195+@q196+@q197+@q198+@q199+@q200+
			@q201+@q202+@q203+@q204+@q205+@q206+@q207+@q208+@q209+@q210+
			@q211+@q212+@q213+@q214+@q215+@q216+@q217+@q218+@q219+@q220+
			@q221+@q222+@q223+@q224+@q225+@q226+@q227+@q228+@q229+@q230+
			@q231+@q232+@q233+@q234+@q235+@q236+@q237+@q238+@q239+@q240+
			@q241+@q242+@q243+@q244+@q245+@q246+@q247+@q248+@q249+@q250+
			@q251)

		select @index = 1

		select @q1 = N'''', @q2 = N'''', @q3 = N'''', @q4 = N'''', @q5 = N'''', @q6 = N'''', @q7 = N'''', @q8 = N'''', @q9 = N'''', @q10 = N'''', 
			@q11 = N'''', @q12 = N'''', @q13 = N'''', @q14 = N'''', @q15 = N'''', @q16 = N'''', @q17 = N'''', @q18 = N'''', @q19 = N'''', @q20 = N'''', 
			@q21 = N'''', @q22 = N'''', @q23 = N'''', @q24 = N'''', @q25 = N'''', @q26 = N'''', @q27 = N'''', @q28 = N'''', @q29 = N'''', @q30 = N'''', 
			@q31 = N'''', @q32 = N'''', @q33 = N'''', @q34 = N'''', @q35 = N'''', @q36 = N'''', @q37 = N'''', @q38 = N'''', @q39 = N'''', @q40 = N'''', 
			@q41 = N'''', @q42 = N'''', @q43 = N'''', @q44 = N'''', @q45 = N'''', @q46 = N'''', @q47 = N'''', @q48 = N'''', @q49 = N'''', @q50 = N'''', 
			@q51 = N'''', @q52 = N'''', @q53 = N'''', @q54 = N'''', @q55 = N'''', @q56 = N'''', @q57 = N'''', @q58 = N'''', @q59 = N'''', @q60 = N'''', 
			@q61 = N'''', @q62 = N'''', @q63 = N'''', @q64 = N'''', @q65 = N'''', @q66 = N'''', @q67 = N'''', @q68 = N'''', @q69 = N'''', @q70 = N'''', 
			@q71 = N'''', @q72 = N'''', @q73 = N'''', @q74 = N'''', @q75 = N'''', @q76 = N'''', @q77 = N'''', @q78 = N'''', @q79 = N'''', @q80 = N'''', 
			@q81 = N'''', @q82 = N'''', @q83 = N'''', @q84 = N'''', @q85 = N'''', @q86 = N'''', @q87 = N'''', @q88 = N'''', @q89 = N'''', @q90 = N'''', 
			@q91 = N'''', @q92 = N'''', @q93 = N'''', @q94 = N'''', @q95 = N'''', @q96 = N'''', @q97 = N'''', @q98 = N'''', @q99 = N'''', @q100 = N'''', 
			@q101 = N'''', @q102 = N'''', @q103 = N'''', @q104 = N'''', @q105 = N'''', @q106 = N'''', @q107 = N'''', @q108 = N'''', @q109 = N'''', @q110 = N'''', 
			@q111 = N'''', @q112 = N'''', @q113 = N'''', @q114 = N'''', @q115 = N'''', @q116 = N'''', @q117 = N'''', @q118 = N'''', @q119 = N'''', @q120 = N'''', 
			@q121 = N'''', @q122 = N'''', @q123 = N'''', @q124 = N'''', @q125 = N'''', @q126 = N'''', @q127 = N'''', @q128 = N'''', @q129 = N'''', @q130 = N'''', 
			@q131 = N'''', @q132 = N'''', @q133 = N'''', @q134 = N'''', @q135 = N'''', @q136 = N'''', @q137 = N'''', @q138 = N'''', @q139 = N'''', @q140 = N'''', 
			@q141 = N'''', @q142 = N'''', @q143 = N'''', @q144 = N'''', @q145 = N'''', @q146 = N'''', @q147 = N'''', @q148 = N'''', @q149 = N'''', @q150 = N'''', 
			@q151 = N'''', @q152 = N'''', @q153 = N'''', @q154 = N'''', @q155 = N'''', @q156 = N'''', @q157 = N'''', @q158 = N'''', @q159 = N'''', @q160 = N'''', 
			@q161 = N'''', @q162 = N'''', @q163 = N'''', @q164 = N'''', @q165 = N'''', @q166 = N'''', @q167 = N'''', @q168 = N'''', @q169 = N'''', @q170 = N'''', 
			@q171 = N'''', @q172 = N'''', @q173 = N'''', @q174 = N'''', @q175 = N'''', @q176 = N'''', @q177 = N'''', @q178 = N'''', @q179 = N'''', @q180 = N'''', 
			@q181 = N'''', @q182 = N'''', @q183 = N'''', @q184 = N'''', @q185 = N'''', @q186 = N'''', @q187 = N'''', @q188 = N'''', @q189 = N'''', @q190 = N'''', 
			@q191 = N'''', @q192 = N'''', @q193 = N'''', @q194 = N'''', @q195 = N'''', @q196 = N'''', @q197 = N'''', @q198 = N'''', @q199 = N'''', @q200 = N'''', 
			@q201 = N'''', @q202 = N'''', @q203 = N'''', @q204 = N'''', @q205 = N'''', @q206 = N'''', @q207 = N'''', @q208 = N'''', @q209 = N'''', @q210 = N'''', 
			@q211 = N'''', @q212 = N'''', @q213 = N'''', @q214 = N'''', @q215 = N'''', @q216 = N'''', @q217 = N'''', @q218 = N'''', @q219 = N'''', @q220 = N'''', 
			@q221 = N'''', @q222 = N'''', @q223 = N'''', @q224 = N'''', @q225 = N'''', @q226 = N'''', @q227 = N'''', @q228 = N'''', @q229 = N'''', @q230 = N'''', 
			@q231 = N'''', @q232 = N'''', @q233 = N'''', @q234 = N'''', @q235 = N'''', @q236 = N'''', @q237 = N'''', @q238 = N'''', @q239 = N'''', @q240 = N'''', 
			@q241 = N'''', @q242 = N'''', @q243 = N'''', @q244 = N'''', @q245 = N'''', @q246 = N'''', @q247 = N'''', @q248 = N'''', @q249 = N'''', @q250 = N'''',
			@q251 = N'''''''' /* special ending for this process */

		fetch next from cSettingIDs into @SettingsID
	end
	close cSettingIDs
	deallocate cSettingIDs

	if @hasErrorOccured = 1
	begin
		print ''An error occured - too much data to execute!''
	end
')

/* remove temp stored proc */
if object_id('cs_TEMP_FoldSpamConfiguration', 'P') IS NOT NULL
	exec ('drop procedure cs_TEMP_FoldSpamConfiguration')


--## END Schema Patch ##
Insert into cs_SchemaVersion(Major, Minor, Patch, InstallDate) values (@Major, @Minor, @Patch, GetDate())

Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was applied successfully '

	END
ELSE IF(@Installed is not null)
	BEGIN
Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was already applied on ' + Convert(varchar(50), @Installed)  
	END 
ELSE
	BEGIN
Print 'The patch could not be applied because your current schema is missing previous updates (Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ')' 
	END 
