SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Major int, @Minor int, @Patch int, @Installed DateTime, @Prereqs int

Set @Major = 3;
Set @Minor = 1;
Set @Patch = 29;

Select @Prereqs = isnull(Count(InstallDate),0)  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch<@Patch

Select @Installed = InstallDate  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch=@Patch

If(@Installed is null AND @Prereqs = @Patch)
	BEGIN
--## Schema Patch ##

if exists ( select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME='cs_PostAttachments' and COLUMN_NAME='Content' )
	EXECUTE sp_executesql N'ALTER TABLE cs_PostAttachments ADD CONSTRAINT [DF_cs_PostAttachments_Content] DEFAULT 0x FOR [Content]'

if exists ( select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME='cs_PostAttachments_TEMP' and COLUMN_NAME='Content' )
	EXECUTE sp_executesql N'ALTER TABLE cs_PostAttachments_TEMP ADD CONSTRAINT [DF_cs_PostAttachments_TEMP_Content] DEFAULT 0x FOR [Content]'

--## END Schema Patch ##
Insert into cs_SchemaVersion(Major, Minor, Patch, InstallDate) values (@Major, @Minor, @Patch, GetDate())

Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was applied successfully '

	END
ELSE IF(@Installed is not null)
	BEGIN
Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was already applied on ' + Convert(varchar(50), @Installed)  
	END 
ELSE
	BEGIN
Print 'The patch could not be applied because your current schema is missing previous updates (Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ')' 
	END 
