SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Major int, @Minor int, @Patch int, @Installed DateTime, @Prereqs int

Set @Major = 3;
Set @Minor = 1;
Set @Patch = 7;

Select @Prereqs = isnull(Count(InstallDate),0)  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch<@Patch

Select @Installed = InstallDate  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch=@Patch

If(@Installed is null AND @Prereqs = @Patch)
	BEGIN
--## Schema Patch ##

exec sp_executesql N'CREATE TABLE [dbo].[cs_Thread_Daily_Stats](
	[SectionID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[Day] [datetime] NOT NULL,
	[ViewCount] [int] NOT NULL,
	CONSTRAINT [PK_cs_Thread_Daily_Stats] PRIMARY KEY CLUSTERED (
		[SectionID] ASC,
		[ThreadID] ASC
	) 
) ON [PRIMARY]


/****** Object:  Index [PK_cs_Thread_Daily_Stats]    Script Date: 06/27/2007 12:29:38 ******/
CREATE INDEX [IX_cs_Thread_Daily_Stats_Day] ON [dbo].[cs_Thread_Daily_Stats] 
(
	[Day] DESC
) ON [PRIMARY]'


--## END Schema Patch ##
Insert into cs_SchemaVersion(Major, Minor, Patch, InstallDate) values (@Major, @Minor, @Patch, GetDate())

Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was applied successfully '

	END
ELSE IF(@Installed is not null)
	BEGIN
Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was already applied on ' + Convert(varchar(50), @Installed)  
	END 
ELSE
	BEGIN
Print 'The patch could not be applied because your current schema is missing previous updates (Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ')' 
	END 

