SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

DECLARE @Major int, @Minor int, @Patch int, @Installed DateTime, @Prereqs int

Set @Major = 3;
Set @Minor = 0;
Set @Patch = 5;

Select @Prereqs = isnull(Count(InstallDate),0)  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch<@Patch

Select @Installed = InstallDate  from cs_SchemaVersion where Major=@Major and Minor=@Minor and Patch=@Patch

If(@Installed is null AND @Prereqs = @Patch)
	BEGIN
--## Schema Patch ##

exec sp_executesql N'CREATE TABLE [dbo].[cs_SectionSubscriptions](
	[SubscriptionID] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_cs_SectionSubscriptions_SubscriptionID]  DEFAULT (newid()),
	[SectionID] [int] NOT NULL,
	[Email] [nvarchar](256),
	[SubscriptionType] [int] NOT NULL,
	[UserID] [int] NULL CONSTRAINT [DF_cs_SectionSubscriptions_UserID]  DEFAULT ((-1)),
	[SettingsID] [int] NULL CONSTRAINT [DF_cs_SectionSubscriptions_SettingsID]  DEFAULT ((-1)),
	[DateSubscribed] [datetime] NOT NULL,
	[DateUnsubscribed] [datetime] NULL,
	[SubscriptionFrequency] [int] NOT NULL CONSTRAINT [DF_cs_SectionSubscriptions_SubscriptionFrequency]  DEFAULT ((1)),
	[IsConfirmed] [bit] NOT NULL CONSTRAINT [DF_cs_SectionSubscriptions_IsConfirmed]  DEFAULT ((0)),
		 CONSTRAINT [PK_cs_SectionSubscriptions] PRIMARY KEY CLUSTERED 
		(
			[SubscriptionID] ASC
		) ON [PRIMARY]
		) ON [PRIMARY]'

--## END Schema Patch ##
Insert into cs_SchemaVersion(Major, Minor, Patch, InstallDate) values (@Major, @Minor, @Patch, GetDate())

Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was applied successfully '

	END
ELSE IF(@Installed is not null)
	BEGIN
Print 'Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ' was already applied on ' + Convert(varchar(50), @Installed)  
	END 
ELSE
	BEGIN
Print 'The patch could not be applied because your current schema is missing previous updates (Schema Patch v' + Convert(Varchar(2),@Major) + '.' + Convert(Varchar(2),@Minor) + '.' +  Convert(Varchar(3),@Patch) + ')' 
	END 

